"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    application_id: str,
    campaign_id: str,
    page_size: str = None,
    token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about all the activities for a campaign.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        campaign_id(str): The unique identifier for the campaign.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        token(str, optional): The NextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.campaign.activity.get_all(
                ctx, application_id=value, campaign_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.campaign.activity.get_all application_id=value, campaign_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_campaign_activities",
        op_kwargs={
            "ApplicationId": application_id,
            "CampaignId": campaign_id,
            "PageSize": page_size,
            "Token": token,
        },
    )
