"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def remove(
    hub, ctx, application_id: str, attribute_type: str, update_attributes_request: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        attribute_type(str):  The type of attribute or attributes to remove. Valid values are: endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user opted in or out of receiving communications from you through a specific type of channel. endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items left in a cart. endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.
        update_attributes_request(Dict): Specifies one or more attributes to remove from all the endpoints that are associated with an application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.attribute.remove(
                ctx, application_id=value, attribute_type=value, update_attributes_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.attribute.remove application_id=value, attribute_type=value, update_attributes_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="remove_attributes",
        op_kwargs={
            "ApplicationId": application_id,
            "AttributeType": attribute_type,
            "UpdateAttributesRequest": update_attributes_request,
        },
    )
