"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, page_size: str = None, token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about all the applications that are associated with your Amazon Pinpoint account.

    Args:
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        token(str, optional): The NextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.apps.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.apps.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_apps",
        op_kwargs={"PageSize": page_size, "Token": token},
    )
