"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    application_id: str,
    kpi_name: str,
    end_time: str = None,
    next_token: str = None,
    page_size: str = None,
    start_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.
        end_time(str, optional): The last date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019. Defaults to None.
        kpi_name(str): The name of the metric, also referred to as a key performance indicator (KPI), to retrieve data for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid values, see the Amazon Pinpoint Developer Guide.
        next_token(str, optional): The  string that specifies which page of results to return in a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        page_size(str, optional): The maximum number of items to include in each page of a paginated response. This parameter is not supported for application, campaign, and journey metrics. Defaults to None.
        start_time(str, optional): The first date and time to retrieve data for, as part of an inclusive date range that filters the query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current day. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.application.date_range_kpi.get(
                ctx, application_id=value, kpi_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.application.date_range_kpi.get application_id=value, kpi_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_application_date_range_kpi",
        op_kwargs={
            "ApplicationId": application_id,
            "EndTime": end_time,
            "KpiName": kpi_name,
            "NextToken": next_token,
            "PageSize": page_size,
            "StartTime": start_time,
        },
    )
