"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, create_application_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

     Creates an application.

    Args:
        create_application_request(Dict): Specifies the display name of an application and the tags to associate with the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.app.create(ctx, create_application_request=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.app.create create_application_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="create_app",
        op_kwargs={"CreateApplicationRequest": create_application_request},
    )


async def delete(hub, ctx, application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.app.delete(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.app.delete application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="delete_app",
        op_kwargs={"ApplicationId": application_id},
    )


async def get(hub, ctx, application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about an application.

    Args:
        application_id(str): The unique identifier for the application. This identifier is displayed as the Project ID on the Amazon Pinpoint console.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pinpoint.app.get(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pinpoint.app.get application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pinpoint",
        operation="get_app",
        op_kwargs={"ApplicationId": application_id},
    )
