"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    service_type: str,
    identifier: str,
    start_time: str,
    end_time: str,
    metric: str,
    group_by: Dict,
    period_in_seconds: int = None,
    partition_by: Dict = None,
    filter_: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    For a specific time period, retrieve the top N dimension keys for a metric.  Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.

    Args:
        service_type(str): The AWS service for which Performance Insights will return metrics. The only valid value for ServiceType is RDS.
        identifier(str): An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data source. To use an Amazon RDS instance as a data source, you specify its DbiResourceId value. For example, specify db-FAIHNTYBKTGAUSUZQYPDS2GW4A .
        start_time(str): The date and time specifying the beginning of the requested time series data. You must specify a StartTime within the past 7 days. The value specified is inclusive, which means that data points equal to or greater than StartTime are returned. The value for StartTime must be earlier than the value for EndTime.
        end_time(str): The date and time specifying the end of the requested time series data. The value specified is exclusive, which means that data points less than (but not equal to) EndTime are returned. The value for EndTime must be later than the value for StartTime.
        metric(str): The name of a Performance Insights metric to be measured. Valid values for Metric are:    db.load.avg - a scaled representation of the number of active sessions for the database engine.    db.sampledload.avg - the raw number of active sessions for the database engine.   If the number of active sessions is less than an internal Performance Insights threshold, db.load.avg and db.sampledload.avg are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with db.load.avg showing the scaled values, db.sampledload.avg showing the raw values, and db.sampledload.avg less than db.load.avg. For most use cases, you can query db.load.avg only. .
        period_in_seconds(int, optional): The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as one second, or as long as one day (86400 seconds). Valid values are:    1 (one second)    60 (one minute)    300 (five minutes)    3600 (one hour)    86400 (twenty-four hours)   If you don't specify PeriodInSeconds, then Performance Insights chooses a value for you, with a goal of returning roughly 100-200 data points in the response. Defaults to None.
        group_by(Dict): A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights returns all dimensions within this group, unless you provide the names of specific dimensions within this group. You can also request that Performance Insights return a limited number of values for a dimension.
        partition_by(Dict, optional): For each dimension specified in GroupBy, specify a secondary dimension to further subdivide the partition keys in the response. Defaults to None.
        filter_(Dict, optional): One or more filters to apply in the request. Restrictions:   Any number of filters by the same dimension, as specified in the GroupBy or Partition parameters.   A single filter for any other dimension in this dimension group.  . Defaults to None.
        max_results(int, optional): The maximum number of items to return in the response. If more items exist than the specified MaxRecords value, a pagination token is included in the response so that the remaining results can be retrieved. . Defaults to None.
        next_token(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the token, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pi.dimension_key.init.describe_all(
                ctx,
                service_type=value,
                identifier=value,
                start_time=value,
                end_time=value,
                metric=value,
                group_by=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pi.dimension_key.init.describe_all service_type=value, identifier=value, start_time=value, end_time=value, metric=value, group_by=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pi",
        operation="describe_dimension_keys",
        op_kwargs={
            "ServiceType": service_type,
            "Identifier": identifier,
            "StartTime": start_time,
            "EndTime": end_time,
            "Metric": metric,
            "PeriodInSeconds": period_in_seconds,
            "GroupBy": group_by,
            "PartitionBy": partition_by,
            "Filter": filter_,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
