"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    service_type: str,
    identifier: str,
    group: str,
    group_identifier: str,
    requested_dimensions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get the attributes of the specified dimension group for a DB instance or data source. For example, if you specify a SQL ID, GetDimensionKeyDetails retrieves the full text of the dimension db.sql.statement associated with this ID. This operation is useful because GetResourceMetrics and DescribeDimensionKeys don't support retrieval of large SQL statement text.

    Args:
        service_type(str): The AWS service for which Performance Insights returns data. The only valid value is RDS.
        identifier(str): The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an AWS Region. When a DB instance is the data source, specify its DbiResourceId value. For example, specify db-ABCDEFGHIJKLMNOPQRSTU1VW2X. .
        group(str): The name of the dimension group. The only valid value is db.sql. Performance Insights searches the specified group for the dimension group ID.
        group_identifier(str): The ID of the dimension group from which to retrieve dimension details. For dimension group db.sql, the group ID is db.sql.id.
        requested_dimensions(List, optional): A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension group db.sql, specify either the full dimension name db.sql.statement or the short dimension name statement. If you don't specify this parameter, Performance Insights returns all dimension data within the specified dimension group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.pi.dimension_key.detail.get_all(
                ctx, service_type=value, identifier=value, group=value, group_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.pi.dimension_key.detail.get_all service_type=value, identifier=value, group=value, group_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="pi",
        operation="get_dimension_key_details",
        op_kwargs={
            "ServiceType": service_type,
            "Identifier": identifier,
            "Group": group,
            "GroupIdentifier": group_identifier,
            "RequestedDimensions": requested_dimensions,
        },
    )
