"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    campaign_arn: str,
    item_id: str = None,
    user_id: str = None,
    num_results: int = None,
    context: Dict = None,
    filter_arn: str = None,
    filter_values: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of recommended items. The required input depends on the recipe type used to create the solution backing the campaign, as follows:   RELATED_ITEMS - itemId required, userId not used   USER_PERSONALIZATION - itemId optional, userId required    Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.

    Args:
        campaign_arn(str): The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
        item_id(str, optional): The item ID to provide recommendations for. Required for RELATED_ITEMS recipe type. Defaults to None.
        user_id(str, optional): The user ID to provide recommendations for. Required for USER_PERSONALIZATION recipe type. Defaults to None.
        num_results(int, optional): The number of results to return. The default is 25. The maximum is 500. Defaults to None.
        context(Dict, optional): The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction information that might be relevant when getting a user's recommendations, such as the user's current location or device type. Defaults to None.
        filter_arn(str, optional): The ARN of the filter to apply to the returned recommendations. For more information, see Filtering Recommendations. When using this parameter, be sure the filter resource is ACTIVE. Defaults to None.
        filter_values(Dict, optional): The values to use when filtering recommendations. For each placeholder parameter in your filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma.  For filter expressions that use an INCLUDE element to include items, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an EXCLUDE element to exclude items, you can omit the filter-values.In this case, Amazon Personalize doesn't use that portion of the expression to filter recommendations. For more information, see Filtering Recommendations. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize_runtime.recommendation.get_all(
                ctx, campaign_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize_runtime.recommendation.get_all campaign_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize-runtime",
        operation="get_recommendations",
        op_kwargs={
            "campaignArn": campaign_arn,
            "itemId": item_id,
            "userId": user_id,
            "numResults": num_results,
            "context": context,
            "filterArn": filter_arn,
            "filterValues": filter_values,
        },
    )
