"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    campaign_arn: str,
    input_list: List,
    user_id: str,
    context: Dict = None,
    filter_arn: str = None,
    filter_values: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely item to be of interest to the user.  The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.

    Args:
        campaign_arn(str): The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
        input_list(List): A list of items (by itemId) to rank. If an item was not included in the training dataset, the item is appended to the end of the reranked list. The maximum is 500.
        user_id(str): The user for which you want the campaign to provide a personalized ranking.
        context(Dict, optional): The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction information that might be relevant when getting a user's recommendations, such as the user's current location or device type. Defaults to None.
        filter_arn(str, optional): The Amazon Resource Name (ARN) of a filter you created to include items or exclude items from recommendations for a given user. For more information, see Filtering Recommendations. Defaults to None.
        filter_values(Dict, optional): The values to use when filtering recommendations. For each placeholder parameter in your filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma.  For filter expressions that use an INCLUDE element to include items, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an EXCLUDE element to exclude items, you can omit the filter-values.In this case, Amazon Personalize doesn't use that portion of the expression to filter recommendations. For more information, see Filtering Recommendations. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize_runtime.personalized_ranking.get(
                ctx, campaign_arn=value, input_list=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize_runtime.personalized_ranking.get campaign_arn=value, input_list=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize-runtime",
        operation="get_personalized_ranking",
        op_kwargs={
            "campaignArn": campaign_arn,
            "inputList": input_list,
            "userId": user_id,
            "context": context,
            "filterArn": filter_arn,
            "filterValues": filter_values,
        },
    )
