"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def put_multiple(hub, ctx, dataset_arn: str, users: List) -> None:
    r"""
    **Autogenerated function**

    Adds one or more users to a Users dataset. For more information see Importing Users Incrementally.

    Args:
        dataset_arn(str): The Amazon Resource Name (ARN) of the Users dataset you are adding the user or users to.
        users(List): A list of user data.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize_event.user.put_multiple(
                ctx, dataset_arn=value, users=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize_event.user.put_multiple dataset_arn=value, users=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize-events",
        operation="put_users",
        op_kwargs={"datasetArn": dataset_arn, "users": users},
    )
