"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def put_multiple(
    hub, ctx, tracking_id: str, session_id: str, event_list: List, user_id: str = None
) -> None:
    r"""
    **Autogenerated function**

    Records user interaction event data. For more information see Recording Events.

    Args:
        tracking_id(str): The tracking ID for the event. The ID is generated by a call to the CreateEventTracker API.
        user_id(str, optional): The user associated with the event. Defaults to None.
        session_id(str): The session ID associated with the user's visit. Your application generates the sessionId when a user first visits your website or uses your application. Amazon Personalize uses the sessionId to associate events with the user before they log in. For more information, see Recording Events.
        event_list(List): A list of event data from the session.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize_event.event.put_multiple(
                ctx, tracking_id=value, session_id=value, event_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize_event.event.put_multiple tracking_id=value, session_id=value, event_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize-events",
        operation="put_events",
        op_kwargs={
            "trackingId": tracking_id,
            "userId": user_id,
            "sessionId": session_id,
            "eventList": event_list,
        },
    )
