"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, solution_arn: str, training_mode: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Trains or retrains an active solution. A solution is created using the CreateSolution operation and must be in the ACTIVE state before calling CreateSolutionVersion. A new version of the solution is created every time you call this operation.  Status  A solution version can be in one of the following states:   CREATE PENDING   CREATE IN_PROGRESS   ACTIVE   CREATE FAILED   CREATE STOPPING   CREATE STOPPED   To get the status of the version, call DescribeSolutionVersion. Wait until the status shows as ACTIVE before calling CreateCampaign. If the status shows as CREATE FAILED, the response includes a failureReason key, which describes why the job failed.  Related APIs     ListSolutionVersions     DescribeSolutionVersion       ListSolutions     CreateSolution     DescribeSolution     DeleteSolution

    Args:
        solution_arn(str): The Amazon Resource Name (ARN) of the solution containing the training configuration information.
        training_mode(str, optional): The scope of training to be performed when creating the solution version. The FULL option trains the solution version based on the entirety of the input solution's training data, while the UPDATE option processes only the data that has changed in comparison to the input solution. Choose UPDATE when you want to incrementally update your solution version instead of creating an entirely new one.  The UPDATE option can only be used when you already have an active solution version created from the input solution using the FULL option and the input solution was trained with the User-Personalization recipe or the HRNN-Coldstart recipe. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.solution.version.init.create(
                ctx, solution_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.solution.version.init.create solution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_solution_version",
        op_kwargs={"solutionArn": solution_arn, "trainingMode": training_mode},
    )


async def describe(hub, ctx, solution_version_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a specific version of a solution. For more information on solutions, see CreateSolution.

    Args:
        solution_version_arn(str): The Amazon Resource Name (ARN) of the solution version.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.solution.version.init.describe(
                ctx, solution_version_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.solution.version.init.describe solution_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_solution_version",
        op_kwargs={"solutionVersionArn": solution_version_arn},
    )


async def list_all(
    hub, ctx, solution_arn: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of solution versions for the given solution. When a solution is not specified, all the solution versions associated with the account are listed. The response provides the properties for each solution version, including the Amazon Resource Name (ARN). For more information on solutions, see CreateSolution.

    Args:
        solution_arn(str, optional): The Amazon Resource Name (ARN) of the solution. Defaults to None.
        next_token(str, optional): A token returned from the previous call to ListSolutionVersions for getting the next set of solution versions (if they exist). Defaults to None.
        max_results(int, optional): The maximum number of solution versions to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.solution.version.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.solution.version.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_solution_versions",
        op_kwargs={
            "solutionArn": solution_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
