"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, solution_version_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the metrics for the specified solution version.

    Args:
        solution_version_arn(str): The Amazon Resource Name (ARN) of the solution version for which to get metrics.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.solution.metric.get_all(
                ctx, solution_version_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.solution.metric.get_all solution_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="get_solution_metrics",
        op_kwargs={"solutionVersionArn": solution_version_arn},
    )
