"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    dataset_group_arn: str,
    perform_hpo: bool = None,
    perform_auto_ml: bool = None,
    recipe_arn: str = None,
    event_type: str = None,
    solution_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates the configuration for training a model. A trained model is known as a solution. After the configuration is created, you train the model (create a solution) by calling the CreateSolutionVersion operation. Every time you call CreateSolutionVersion, a new version of the solution is created. After creating a solution version, you check its accuracy by calling GetSolutionMetrics. When you are satisfied with the version, you deploy it using CreateCampaign. The campaign provides recommendations to a client through the GetRecommendations API. To train a model, Amazon Personalize requires training data and a recipe. The training data comes from the dataset group that you provide in the request. A recipe specifies the training algorithm and a feature transformation. You can specify one of the predefined recipes provided by Amazon Personalize. Alternatively, you can specify performAutoML and Amazon Personalize will analyze your data and select the optimum USER_PERSONALIZATION recipe for you.  Amazon Personalize doesn't support configuring the hpoObjective for solution hyperparameter optimization at this time.   Status  A solution can be in one of the following states:   CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED   DELETE PENDING > DELETE IN_PROGRESS   To get the status of the solution, call DescribeSolution. Wait until the status shows as ACTIVE before calling CreateSolutionVersion.  Related APIs     ListSolutions     CreateSolutionVersion     DescribeSolution     DeleteSolution       ListSolutionVersions     DescribeSolutionVersion

    Args:
        name(str): The name for the solution.
        perform_hpo(bool, optional): Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is false. When performing AutoML, this parameter is always true and you should not set it to false. Defaults to None.
        perform_auto_ml(bool, optional): Whether to perform automated machine learning (AutoML). The default is false. For this case, you must specify recipeArn. When set to true, Amazon Personalize analyzes your training data and selects the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit recipeArn. Amazon Personalize determines the optimal recipe by running tests with different values for the hyperparameters. AutoML lengthens the training process as compared to selecting a specific recipe. Defaults to None.
        recipe_arn(str, optional): The ARN of the recipe to use for model training. Only specified when performAutoML is false. Defaults to None.
        dataset_group_arn(str): The Amazon Resource Name (ARN) of the dataset group that provides the training data.
        event_type(str, optional): When your have multiple event types (using an EVENT_TYPE schema field), this parameter specifies which event type (for example, 'click' or 'like') is used for training the model. If you do not provide an eventType, Amazon Personalize will use all interactions for training with equal weight regardless of type. Defaults to None.
        solution_config(Dict, optional): The configuration to use with the solution. When performAutoML is set to true, Amazon Personalize only evaluates the autoMLConfig section of the solution configuration.  Amazon Personalize doesn't support configuring the hpoObjective at this time. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.solution.init.create(
                ctx, name=value, dataset_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.solution.init.create name=value, dataset_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_solution",
        op_kwargs={
            "name": name,
            "performHPO": perform_hpo,
            "performAutoML": perform_auto_ml,
            "recipeArn": recipe_arn,
            "datasetGroupArn": dataset_group_arn,
            "eventType": event_type,
            "solutionConfig": solution_config,
        },
    )


async def delete(hub, ctx, solution_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes all versions of a solution and the Solution object itself. Before deleting a solution, you must delete all campaigns based on the solution. To determine what campaigns are using the solution, call ListCampaigns and supply the Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated SolutionVersion is in the CREATE PENDING or IN PROGRESS state. For more information on solutions, see CreateSolution.

    Args:
        solution_arn(str): The ARN of the solution to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.solution.init.delete(ctx, solution_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.solution.init.delete solution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="delete_solution",
        op_kwargs={"solutionArn": solution_arn},
    )


async def describe(hub, ctx, solution_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a solution. For more information on solutions, see CreateSolution.

    Args:
        solution_arn(str): The Amazon Resource Name (ARN) of the solution to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.solution.init.describe(ctx, solution_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.solution.init.describe solution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_solution",
        op_kwargs={"solutionArn": solution_arn},
    )


async def list_all(
    hub,
    ctx,
    dataset_group_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the solutions associated with the account are listed. The response provides the properties for each solution, including the Amazon Resource Name (ARN). For more information on solutions, see CreateSolution.

    Args:
        dataset_group_arn(str, optional): The Amazon Resource Name (ARN) of the dataset group. Defaults to None.
        next_token(str, optional): A token returned from the previous call to ListSolutions for getting the next set of solutions (if they exist). Defaults to None.
        max_results(int, optional): The maximum number of solutions to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.solution.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.solution.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_solutions",
        op_kwargs={
            "datasetGroupArn": dataset_group_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
