"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, schema: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON format. Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set of required field and keywords. You specify a schema when you call CreateDataset.  Related APIs     ListSchemas     DescribeSchema     DeleteSchema

    Args:
        name(str): The name for the schema.
        schema(str): A schema in Avro JSON format.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.schema.create(ctx, name=value, schema=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.schema.create name=value, schema=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_schema",
        op_kwargs={"name": name, "schema": schema},
    )


async def delete(hub, ctx, schema_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more information on schemas, see CreateSchema.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) of the schema to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.schema.delete(ctx, schema_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.schema.delete schema_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="delete_schema",
        op_kwargs={"schemaArn": schema_arn},
    )


async def describe(hub, ctx, schema_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a schema. For more information on schemas, see CreateSchema.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) of the schema to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.schema.describe(ctx, schema_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.schema.describe schema_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_schema",
        op_kwargs={"schemaArn": schema_arn},
    )
