"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, recipe_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a recipe. A recipe contains three items:   An algorithm that trains a model.   Hyperparameters that govern the training.   Feature transformation information for modifying the input data before training.   Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the CreateSolution API. CreateSolution trains a model by using the algorithm in the specified recipe and a training dataset. The solution, when deployed as a campaign, can provide recommendations using the GetRecommendations API.

    Args:
        recipe_arn(str): The Amazon Resource Name (ARN) of the recipe to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.recipe.describe(ctx, recipe_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.recipe.describe recipe_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_recipe",
        op_kwargs={"recipeArn": recipe_arn},
    )


async def list_all(
    hub,
    ctx,
    recipe_provider: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's Amazon Resource Name (ARN).

    Args:
        recipe_provider(str, optional): The default is SERVICE. Defaults to None.
        next_token(str, optional): A token returned from the previous call to ListRecipes for getting the next set of recipes (if they exist). Defaults to None.
        max_results(int, optional): The maximum number of recipes to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.recipe.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.recipe.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_recipes",
        op_kwargs={
            "recipeProvider": recipe_provider,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
