"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "filter"


async def create(
    hub, ctx, name: str, dataset_group_arn: str, filter_expression: str
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a recommendation filter. For more information, see filter.

    Args:
        name(str): The name of the filter to create.
        dataset_group_arn(str): The ARN of the dataset group that the filter will belong to.
        filter_expression(str): The filter expression defines which items are included or excluded from recommendations. Filter expression must follow specific format rules. For information about filter expression structure and syntax, see filter-expressions.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.filter_.create(
                ctx, name=value, dataset_group_arn=value, filter_expression=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.filter.create name=value, dataset_group_arn=value, filter_expression=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_filter",
        op_kwargs={
            "name": name,
            "datasetGroupArn": dataset_group_arn,
            "filterExpression": filter_expression,
        },
    )


async def delete(hub, ctx, filter_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a filter.

    Args:
        filter_arn(str): The ARN of the filter to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.filter_.delete(ctx, filter_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.filter.delete filter_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="delete_filter",
        op_kwargs={"filterArn": filter_arn},
    )


async def describe(hub, ctx, filter_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a filter's properties.

    Args:
        filter_arn(str): The ARN of the filter to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.filter_.describe(ctx, filter_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.filter.describe filter_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_filter",
        op_kwargs={"filterArn": filter_arn},
    )


async def list_all(
    hub,
    ctx,
    dataset_group_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all filters that belong to a given dataset group.

    Args:
        dataset_group_arn(str, optional): The ARN of the dataset group that contains the filters. Defaults to None.
        next_token(str, optional): A token returned from the previous call to ListFilters for getting the next set of filters (if they exist). Defaults to None.
        max_results(int, optional): The maximum number of filters to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.filter_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.filter.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_filters",
        op_kwargs={
            "datasetGroupArn": dataset_group_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
