"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, feature_transformation_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the given feature transformation.

    Args:
        feature_transformation_arn(str): The Amazon Resource Name (ARN) of the feature transformation to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.feature_transformation.describe(
                ctx, feature_transformation_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.feature_transformation.describe feature_transformation_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_feature_transformation",
        op_kwargs={"featureTransformationArn": feature_transformation_arn},
    )
