"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, dataset_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates an event tracker that you use when adding event data to a specified dataset group using the PutEvents API.  Only one event tracker can be associated with a dataset group. You will get an error if you call CreateEventTracker using the same dataset group as an existing event tracker.  When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use the PutEvents operation. Amazon Personalize then appends the event data to the Interactions dataset of the dataset group you specify in your event tracker.  The event tracker can be in one of the following states:   CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED   DELETE PENDING > DELETE IN_PROGRESS   To get the status of the event tracker, call DescribeEventTracker.  The event tracker must be in the ACTIVE state before using the tracking ID.   Related APIs     ListEventTrackers     DescribeEventTracker     DeleteEventTracker

    Args:
        name(str): The name for the event tracker.
        dataset_group_arn(str): The Amazon Resource Name (ARN) of the dataset group that receives the event data.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.event_tracker.create(
                ctx, name=value, dataset_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.event_tracker.create name=value, dataset_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_event_tracker",
        op_kwargs={"name": name, "datasetGroupArn": dataset_group_arn},
    )


async def delete(hub, ctx, event_tracker_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the event tracker. Does not delete the event-interactions dataset from the associated dataset group. For more information on event trackers, see CreateEventTracker.

    Args:
        event_tracker_arn(str): The Amazon Resource Name (ARN) of the event tracker to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.event_tracker.delete(ctx, event_tracker_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.event_tracker.delete event_tracker_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="delete_event_tracker",
        op_kwargs={"eventTrackerArn": event_tracker_arn},
    )


async def describe(hub, ctx, event_tracker_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an event tracker. The response includes the trackingId and status of the event tracker. For more information on event trackers, see CreateEventTracker.

    Args:
        event_tracker_arn(str): The Amazon Resource Name (ARN) of the event tracker to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.event_tracker.describe(ctx, event_tracker_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.event_tracker.describe event_tracker_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_event_tracker",
        op_kwargs={"eventTrackerArn": event_tracker_arn},
    )


async def list_all(
    hub,
    ctx,
    dataset_group_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of event trackers associated with the account. The response provides the properties for each event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers, see CreateEventTracker.

    Args:
        dataset_group_arn(str, optional): The ARN of a dataset group used to filter the response. Defaults to None.
        next_token(str, optional): A token returned from the previous call to ListEventTrackers for getting the next set of event trackers (if they exist). Defaults to None.
        max_results(int, optional): The maximum number of event trackers to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.event_tracker.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.event_tracker.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_event_trackers",
        op_kwargs={
            "datasetGroupArn": dataset_group_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
