"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, name: str, schema_arn: str, dataset_group_arn: str, dataset_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an empty dataset and adds it to the specified dataset group. Use CreateDatasetImportJob to import your training data to a dataset. There are three types of datasets:   Interactions   Items   Users   Each dataset type has an associated schema with required field types. Only the Interactions dataset is required in order to train a model (also referred to as creating a solution). A dataset can be in one of the following states:   CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED   DELETE PENDING > DELETE IN_PROGRESS   To get the status of the dataset, call DescribeDataset.  Related APIs     CreateDatasetGroup     ListDatasets     DescribeDataset     DeleteDataset

    Args:
        name(str): The name for the dataset.
        schema_arn(str): The ARN of the schema to associate with the dataset. The schema defines the dataset fields.
        dataset_group_arn(str): The Amazon Resource Name (ARN) of the dataset group to add the dataset to.
        dataset_type(str): The type of dataset. One of the following (case insensitive) values:   Interactions   Items   Users  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.init.create(
                ctx, name=value, schema_arn=value, dataset_group_arn=value, dataset_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.init.create name=value, schema_arn=value, dataset_group_arn=value, dataset_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_dataset",
        op_kwargs={
            "name": name,
            "schemaArn": schema_arn,
            "datasetGroupArn": dataset_group_arn,
            "datasetType": dataset_type,
        },
    )


async def delete(hub, ctx, dataset_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a dataset. You can't delete a dataset if an associated DatasetImportJob or SolutionVersion is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see CreateDataset.

    Args:
        dataset_arn(str): The Amazon Resource Name (ARN) of the dataset to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.init.delete(ctx, dataset_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.init.delete dataset_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="delete_dataset",
        op_kwargs={"datasetArn": dataset_arn},
    )


async def describe(hub, ctx, dataset_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the given dataset. For more information on datasets, see CreateDataset.

    Args:
        dataset_arn(str): The Amazon Resource Name (ARN) of the dataset to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.init.describe(ctx, dataset_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.init.describe dataset_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_dataset",
        op_kwargs={"datasetArn": dataset_arn},
    )


async def list_all(
    hub,
    ctx,
    dataset_group_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of datasets contained in the given dataset group. The response provides the properties for each dataset, including the Amazon Resource Name (ARN). For more information on datasets, see CreateDataset.

    Args:
        dataset_group_arn(str, optional): The Amazon Resource Name (ARN) of the dataset group that contains the datasets to list. Defaults to None.
        next_token(str, optional): A token returned from the previous call to ListDatasetImportJobs for getting the next set of dataset import jobs (if they exist). Defaults to None.
        max_results(int, optional): The maximum number of datasets to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_datasets",
        op_kwargs={
            "datasetGroupArn": dataset_group_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
