"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, job_name: str, dataset_arn: str, data_source: Dict, role_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it internally. For information on granting access to your Amazon S3 bucket, see Giving Amazon Personalize Access to Amazon S3 Resources.   The dataset import job replaces any existing data in the dataset that you imported in bulk.   Status  A dataset import job can be in one of the following states:   CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED   To get the status of the import job, call DescribeDatasetImportJob, providing the Amazon Resource Name (ARN) of the dataset import job. The dataset import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a failureReason key, which describes why the job failed.  Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.   Related APIs     ListDatasetImportJobs     DescribeDatasetImportJob

    Args:
        job_name(str): The name for the dataset import job.
        dataset_arn(str): The ARN of the dataset that receives the imported data.
        data_source(Dict): The Amazon S3 bucket that contains the training data to import.
        role_arn(str): The ARN of the IAM role that has permissions to read from the Amazon S3 data source.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.import_job.create(
                ctx, job_name=value, dataset_arn=value, data_source=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.import_job.create job_name=value, dataset_arn=value, data_source=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_dataset_import_job",
        op_kwargs={
            "jobName": job_name,
            "datasetArn": dataset_arn,
            "dataSource": data_source,
            "roleArn": role_arn,
        },
    )


async def describe(hub, ctx, dataset_import_job_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the dataset import job created by CreateDatasetImportJob, including the import job status.

    Args:
        dataset_import_job_arn(str): The Amazon Resource Name (ARN) of the dataset import job to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.import_job.describe(
                ctx, dataset_import_job_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.import_job.describe dataset_import_job_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_dataset_import_job",
        op_kwargs={"datasetImportJobArn": dataset_import_job_arn},
    )


async def list_all(
    hub, ctx, dataset_arn: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the dataset import jobs associated with the account are listed. The response provides the properties for each dataset import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see CreateDatasetImportJob. For more information on datasets, see CreateDataset.

    Args:
        dataset_arn(str, optional): The Amazon Resource Name (ARN) of the dataset to list the dataset import jobs for. Defaults to None.
        next_token(str, optional): A token returned from the previous call to ListDatasetImportJobs for getting the next set of dataset import jobs (if they exist). Defaults to None.
        max_results(int, optional): The maximum number of dataset import jobs to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.import_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.import_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_dataset_import_jobs",
        op_kwargs={
            "datasetArn": dataset_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
