"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, name: str, role_arn: str = None, kms_key_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an empty dataset group. A dataset group contains related datasets that supply data for training a model. A dataset group can contain at most three datasets, one for each type of dataset:   Interactions   Items   Users   To train a model (create a solution), a dataset group that contains an Interactions dataset is required. Call CreateDataset to add a dataset to the group. A dataset group can be in one of the following states:   CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED   DELETE PENDING   To get the status of the dataset group, call DescribeDatasetGroup. If the status shows as CREATE FAILED, the response includes a failureReason key, which describes why the creation failed.  You must wait until the status of the dataset group is ACTIVE before adding a dataset to the group.  You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.  APIs that require a dataset group ARN in the request     CreateDataset     CreateEventTracker     CreateSolution     Related APIs     ListDatasetGroups     DescribeDatasetGroup     DeleteDatasetGroup

    Args:
        name(str): The name for the new dataset group.
        role_arn(str, optional): The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key. Defaults to None.
        kms_key_arn(str, optional): The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.group.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.group.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_dataset_group",
        op_kwargs={"name": name, "roleArn": role_arn, "kmsKeyArn": kms_key_arn},
    )


async def delete(hub, ctx, dataset_group_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a dataset group. Before you delete a dataset group, you must delete the following:   All associated event trackers.   All associated solutions.   All datasets in the dataset group.

    Args:
        dataset_group_arn(str): The ARN of the dataset group to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.group.delete(ctx, dataset_group_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.group.delete dataset_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="delete_dataset_group",
        op_kwargs={"datasetGroupArn": dataset_group_arn},
    )


async def describe(hub, ctx, dataset_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the given dataset group. For more information on dataset groups, see CreateDatasetGroup.

    Args:
        dataset_group_arn(str): The Amazon Resource Name (ARN) of the dataset group to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.group.describe(ctx, dataset_group_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.group.describe dataset_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_dataset_group",
        op_kwargs={"datasetGroupArn": dataset_group_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of dataset groups. The response provides the properties for each dataset group, including the Amazon Resource Name (ARN). For more information on dataset groups, see CreateDatasetGroup.

    Args:
        next_token(str, optional): A token returned from the previous call to ListDatasetGroups for getting the next set of dataset groups (if they exist). Defaults to None.
        max_results(int, optional): The maximum number of dataset groups to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.dataset.group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.dataset.group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_dataset_groups",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
