"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    solution_version_arn: str,
    min_provisioned_tps: int = None,
    campaign_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a campaign by deploying a solution version. When a client calls the GetRecommendations and GetPersonalizedRanking APIs, a campaign is specified in the request.  Minimum Provisioned TPS and Auto-Scaling  A transaction is a single GetRecommendations or GetPersonalizedRanking call. Transactions per second (TPS) is the throughput and unit of billing for Amazon Personalize. The minimum provisioned TPS (minProvisionedTPS) specifies the baseline throughput provisioned by Amazon Personalize, and thus, the minimum billing charge.   If your TPS increases beyond minProvisionedTPS, Amazon Personalize auto-scales the provisioned capacity up and down, but never below minProvisionedTPS. There's a short time delay while the capacity is increased that might cause loss of transactions. The actual TPS used is calculated as the average requests/second within a 5-minute window. You pay for maximum of either the minimum provisioned TPS or the actual TPS. We recommend starting with a low minProvisionedTPS, track your usage using Amazon CloudWatch metrics, and then increase the minProvisionedTPS as necessary.  Status  A campaign can be in one of the following states:   CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED   DELETE PENDING > DELETE IN_PROGRESS   To get the campaign status, call DescribeCampaign.  Wait until the status of the campaign is ACTIVE before asking the campaign for recommendations.   Related APIs     ListCampaigns     DescribeCampaign     UpdateCampaign     DeleteCampaign

    Args:
        name(str): A name for the new campaign. The campaign name must be unique within your account.
        solution_version_arn(str): The Amazon Resource Name (ARN) of the solution version to deploy.
        min_provisioned_tps(int, optional): Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support. Defaults to None.
        campaign_config(Dict, optional): The configuration details of a campaign. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.campaign.create(
                ctx, name=value, solution_version_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.campaign.create name=value, solution_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_campaign",
        op_kwargs={
            "name": name,
            "solutionVersionArn": solution_version_arn,
            "minProvisionedTPS": min_provisioned_tps,
            "campaignConfig": campaign_config,
        },
    )


async def delete(hub, ctx, campaign_arn: str) -> None:
    r"""
    **Autogenerated function**

    Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted and can be redeployed when needed. A deleted campaign can no longer be specified in a GetRecommendations request. For more information on campaigns, see CreateCampaign.

    Args:
        campaign_arn(str): The Amazon Resource Name (ARN) of the campaign to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.campaign.delete(ctx, campaign_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.campaign.delete campaign_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="delete_campaign",
        op_kwargs={"campaignArn": campaign_arn},
    )


async def describe(hub, ctx, campaign_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the given campaign, including its status. A campaign can be in one of the following states:   CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED   DELETE PENDING > DELETE IN_PROGRESS   When the status is CREATE FAILED, the response includes the failureReason key, which describes why. For more information on campaigns, see CreateCampaign.

    Args:
        campaign_arn(str): The Amazon Resource Name (ARN) of the campaign.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.campaign.describe(ctx, campaign_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.campaign.describe campaign_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_campaign",
        op_kwargs={"campaignArn": campaign_arn},
    )


async def list_all(
    hub, ctx, solution_arn: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns associated with the account are listed. The response provides the properties for each campaign, including the Amazon Resource Name (ARN). For more information on campaigns, see CreateCampaign.

    Args:
        solution_arn(str, optional): The Amazon Resource Name (ARN) of the solution to list the campaigns for. When a solution is not specified, all the campaigns associated with the account are listed. Defaults to None.
        next_token(str, optional): A token returned from the previous call to ListCampaigns for getting the next set of campaigns (if they exist). Defaults to None.
        max_results(int, optional): The maximum number of campaigns to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.campaign.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.campaign.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_campaigns",
        op_kwargs={
            "solutionArn": solution_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    campaign_arn: str,
    solution_version_arn: str = None,
    min_provisioned_tps: int = None,
    campaign_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a campaign by either deploying a new solution or changing the value of the campaign's minProvisionedTPS parameter. To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the DescribeCampaign API.  You must wait until the status of the updated campaign is ACTIVE before asking the campaign for recommendations.  For more information on campaigns, see CreateCampaign.

    Args:
        campaign_arn(str): The Amazon Resource Name (ARN) of the campaign.
        solution_version_arn(str, optional): The ARN of a new solution version to deploy. Defaults to None.
        min_provisioned_tps(int, optional): Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support. Defaults to None.
        campaign_config(Dict, optional): The configuration details of a campaign. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.campaign.update(ctx, campaign_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.campaign.update campaign_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="update_campaign",
        op_kwargs={
            "campaignArn": campaign_arn,
            "solutionVersionArn": solution_version_arn,
            "minProvisionedTPS": min_provisioned_tps,
            "campaignConfig": campaign_config,
        },
    )
