"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    job_name: str,
    solution_version_arn: str,
    job_input: Dict,
    job_output: Dict,
    role_arn: str,
    filter_arn: str = None,
    num_results: int = None,
    batch_inference_job_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a batch inference job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see recommendations-batch.

    Args:
        job_name(str): The name of the batch inference job to create.
        solution_version_arn(str): The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference recommendations.
        filter_arn(str, optional): The ARN of the filter to apply to the batch inference job. For more information on using filters, see Filtering Batch Recommendations.. Defaults to None.
        num_results(int, optional): The number of recommendations to retreive. Defaults to None.
        job_input(Dict): The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be in JSON format.
        job_output(Dict): The path to the Amazon S3 bucket where the job's output will be stored.
        role_arn(str): The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output Amazon S3 buckets respectively.
        batch_inference_job_config(Dict, optional): The configuration details of a batch inference job. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.batch_inference_job.create(
                ctx,
                job_name=value,
                solution_version_arn=value,
                job_input=value,
                job_output=value,
                role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.batch_inference_job.create job_name=value, solution_version_arn=value, job_input=value, job_output=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="create_batch_inference_job",
        op_kwargs={
            "jobName": job_name,
            "solutionVersionArn": solution_version_arn,
            "filterArn": filter_arn,
            "numResults": num_results,
            "jobInput": job_input,
            "jobOutput": job_output,
            "roleArn": role_arn,
            "batchInferenceJobConfig": batch_inference_job_config,
        },
    )


async def describe(hub, ctx, batch_inference_job_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate the recommendations.

    Args:
        batch_inference_job_arn(str): The ARN of the batch inference job to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.batch_inference_job.describe(
                ctx, batch_inference_job_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.batch_inference_job.describe batch_inference_job_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_batch_inference_job",
        op_kwargs={"batchInferenceJobArn": batch_inference_job_arn},
    )


async def list_all(
    hub,
    ctx,
    solution_version_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the batch inference jobs that have been performed off of a solution version.

    Args:
        solution_version_arn(str, optional): The Amazon Resource Name (ARN) of the solution version from which the batch inference jobs were created. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of batch inference job results to return in each page. The default value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.batch_inference_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.batch_inference_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="list_batch_inference_jobs",
        op_kwargs={
            "solutionVersionArn": solution_version_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
