"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, algorithm_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the given algorithm.

    Args:
        algorithm_arn(str): The Amazon Resource Name (ARN) of the algorithm to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.personalize.algorithm.describe(ctx, algorithm_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.personalize.algorithm.describe algorithm_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="personalize",
        operation="describe_algorithm",
        op_kwargs={"algorithmArn": algorithm_arn},
    )
