"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, site_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the site.

    Args:
        site_id(str): The ID of the site.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.outpost.site.delete(ctx, site_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.outpost.site.delete site_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="outposts",
        operation="delete_site",
        op_kwargs={"SiteId": site_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the sites for the specified AWS account.

    Args:
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum page size. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.outpost.site.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.outpost.site.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="outposts",
        operation="list_sites",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
