"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "instance_type"


async def get_all(
    hub, ctx, outpost_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the instance types for the specified Outpost.

    Args:
        outpost_id(str): The ID of the Outpost.
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum page size. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.outpost.outpost.instance_type_.get_all(ctx, outpost_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.outpost.outpost.instance_type.get_all outpost_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="outposts",
        operation="get_outpost_instance_types",
        op_kwargs={
            "OutpostId": outpost_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
