"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    site_id: str,
    description: str = None,
    availability_zone: str = None,
    availability_zone_id: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Outpost. You can specify AvailabilityZone or AvailabilityZoneId.

    Args:
        name(str): The name of the Outpost.
        description(str, optional): The description of the Outpost. Defaults to None.
        site_id(str): The ID of the site.
        availability_zone(str, optional): The Availability Zone. Defaults to None.
        availability_zone_id(str, optional): The ID of the Availability Zone. Defaults to None.
        tags(Dict, optional): The tags to apply to the Outpost. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.outpost.outpost.init.create(ctx, name=value, site_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.outpost.outpost.init.create name=value, site_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="outposts",
        operation="create_outpost",
        op_kwargs={
            "Name": name,
            "Description": description,
            "SiteId": site_id,
            "AvailabilityZone": availability_zone,
            "AvailabilityZoneId": availability_zone_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, outpost_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the Outpost.

    Args:
        outpost_id(str): The ID of the Outpost.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.outpost.outpost.init.delete(ctx, outpost_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.outpost.outpost.init.delete outpost_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="outposts",
        operation="delete_outpost",
        op_kwargs={"OutpostId": outpost_id},
    )


async def get(hub, ctx, outpost_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified Outpost.

    Args:
        outpost_id(str): The ID of the Outpost.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.outpost.outpost.init.get(ctx, outpost_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.outpost.outpost.init.get outpost_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="outposts",
        operation="get_outpost",
        op_kwargs={"OutpostId": outpost_id},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    life_cycle_status_filter: List = None,
    availability_zone_filter: List = None,
    availability_zone_id_filter: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a list of the Outposts for your AWS account. Add filters to your request to return a more specific list of results. Use filters to match an Outpost lifecycle status, Availibility Zone (us-east-1a), and AZ ID (use1-az1).  If you specify multiple filters, the filters are joined with an AND, and the request returns only results that match all of the specified filters.

    Args:
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum page size. Defaults to None.
        life_cycle_status_filter(List, optional):  A filter for the lifecycle status of the Outpost.   Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an OR, and the request returns all results that match any of the specified values. . Defaults to None.
        availability_zone_filter(List, optional):  A filter for the Availibility Zone (us-east-1a) of the Outpost.   Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an OR, and the request returns all results that match any of the specified values. . Defaults to None.
        availability_zone_id_filter(List, optional):  A filter for the AZ IDs (use1-az1) of the Outpost.   Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an OR, and the request returns all results that match any of the specified values. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.outpost.outpost.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.outpost.outpost.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="outposts",
        operation="list_outposts",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "LifeCycleStatusFilter": life_cycle_status_filter,
            "AvailabilityZoneFilter": availability_zone_filter,
            "AvailabilityZoneIdFilter": availability_zone_id_filter,
        },
    )
