"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def tag(hub, ctx, resource_id: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds one or more tags to the specified resource. Currently, you can attach tags to the following resources in AWS Organizations.   AWS account   Organization root   Organizational unit (OU)   Policy (any type)   This operation can be called only from the organization's management account.

    Args:
        resource_id(str): The ID of the resource to add a tag to.
        tags(List): A list of tags to add to the specified resource. You can specify any of the following taggable resources.   AWS account – specify the account ID number.   Organizational unit – specify the OU ID that begins with ou- and looks similar to: ou-1a2b-34uvwxyz     Root – specify the root ID that begins with r- and looks similar to: r-1a2b     Policy – specify the policy ID that begins with p- andlooks similar to: p-12abcdefg3     For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to null.  If any one of the tags is invalid or if you exceed the allowed number of tags for an account user, then the entire request fails and the account is not created. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.resource.tag(ctx, resource_id=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.resource.tag resource_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="tag_resource",
        op_kwargs={"ResourceId": resource_id, "Tags": tags},
    )


async def untag(hub, ctx, resource_id: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes any tags with the specified keys from the specified resource. You can attach tags to the following resources in AWS Organizations.   AWS account   Organization root   Organizational unit (OU)   Policy (any type)   This operation can be called only from the organization's management account.

    Args:
        resource_id(str): The ID of the resource to remove a tag from. You can specify any of the following taggable resources.   AWS account – specify the account ID number.   Organizational unit – specify the OU ID that begins with ou- and looks similar to: ou-1a2b-34uvwxyz     Root – specify the root ID that begins with r- and looks similar to: r-1a2b     Policy – specify the policy ID that begins with p- andlooks similar to: p-12abcdefg3    .
        tag_keys(List): The list of keys for tags to remove from the specified resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.resource.untag(
                ctx, resource_id=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.resource.untag resource_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="untag_resource",
        op_kwargs={"ResourceId": resource_id, "TagKeys": tag_keys},
    )
