"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def disable(hub, ctx, root_id: str, policy_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables an organizational policy type in a root. A policy of a certain type can be attached to entities in a root only if that type is enabled in the root. After you perform this operation, you no longer can attach policies of the specified type to that root or to any organizational unit (OU) or account in that root. You can undo this by using the EnablePolicyType operation. This is an asynchronous request that AWS performs in the background. If you disable a policy type for a root, it still appears enabled for the organization if all features are enabled for the organization. AWS recommends that you first use ListRoots to see the status of policy types for a specified root, and then use this operation. This operation can be called only from the organization's management account.  To view the status of available policy types in the organization, use DescribeOrganization.

    Args:
        root_id(str): The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID from the ListRoots operation. The regex pattern for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.
        policy_type(str): The policy type that you want to disable in this root. You can specify one of the following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY     SERVICE_CONTROL_POLICY     TAG_POLICY   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.policy.type_.disable(
                ctx, root_id=value, policy_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.policy.type.disable root_id=value, policy_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="disable_policy_type",
        op_kwargs={"RootId": root_id, "PolicyType": policy_type},
    )


async def enable(hub, ctx, root_id: str, policy_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Enables a policy type in a root. After you enable a policy type in a root, you can attach policies of that type to the root, any organizational unit (OU), or account in that root. You can undo this by using the DisablePolicyType operation. This is an asynchronous request that AWS performs in the background. AWS recommends that you first use ListRoots to see the status of policy types for a specified root, and then use this operation. This operation can be called only from the organization's management account. You can enable a policy type in a root only if that policy type is available in the organization. To view the status of available policy types in the organization, use DescribeOrganization.

    Args:
        root_id(str): The unique identifier (ID) of the root in which you want to enable a policy type. You can get the ID from the ListRoots operation. The regex pattern for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.
        policy_type(str): The policy type that you want to enable. You can specify one of the following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY     SERVICE_CONTROL_POLICY     TAG_POLICY   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.policy.type_.enable(
                ctx, root_id=value, policy_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.policy.type.enable root_id=value, policy_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="enable_policy_type",
        op_kwargs={"RootId": root_id, "PolicyType": policy_type},
    )
