"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(hub, ctx, policy_id: str, target_id: str) -> None:
    r"""
    **Autogenerated function**

    Attaches a policy to a root, an organizational unit (OU), or an individual account. How the policy affects accounts depends on the type of policy. Refer to the AWS Organizations User Guide for information about each policy type:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY     SERVICE_CONTROL_POLICY     TAG_POLICY    This operation can be called only from the organization's management account.

    Args:
        policy_id(str): The unique identifier (ID) of the policy that you want to attach to the target. You can get the ID for the policy by calling the ListPolicies operation. The regex pattern for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
        target_id(str): The unique identifier (ID) of the root, OU, or account that you want to attach the policy to. You can get the ID by calling the ListRoots, ListOrganizationalUnitsForParent, or ListAccounts operations. The regex pattern for a target ID string requires one of the following:    Root - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.    Account - A string that consists of exactly 12 digits.    Organizational unit (OU) - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.policy.init.attach(
                ctx, policy_id=value, target_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.policy.init.attach policy_id=value, target_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="attach_policy",
        op_kwargs={"PolicyId": policy_id, "TargetId": target_id},
    )


async def create(
    hub, ctx, content: str, description: str, name: str, type_: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual AWS account. For more information about policies and their use, see Managing Organization Policies. If the request includes tags, then the requester must have the organizations:TagResource permission. This operation can be called only from the organization's management account.

    Args:
        content(str): The policy text content to add to the new policy. The text that you supply must adhere to the rules of the policy type you specify in the Type parameter.
        description(str): An optional description to assign to the policy.
        name(str): The friendly name to assign to the policy. The regex pattern that is used to validate this parameter is a string of any of the characters in the ASCII character range.
        type_(str): The type of policy to create. You can specify one of the following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY     SERVICE_CONTROL_POLICY     TAG_POLICY   .
        tags(List, optional): A list of tags that you want to attach to the newly created policy. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to null. For more information about tagging, see Tagging AWS Organizations resources in the AWS Organizations User Guide.  If any one of the tags is invalid or if you exceed the allowed number of tags for a policy, then the entire request fails and the policy is not created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.policy.init.create(
                ctx, content=value, description=value, name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.policy.init.create content=value, description=value, name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="create_policy",
        op_kwargs={
            "Content": content,
            "Description": description,
            "Name": name,
            "Type": type_,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, policy_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified policy from your organization. Before you perform this operation, you must first detach the policy from all organizational units (OUs), roots, and accounts. This operation can be called only from the organization's management account.

    Args:
        policy_id(str): The unique identifier (ID) of the policy that you want to delete. You can get the ID from the ListPolicies or ListPoliciesForTarget operations. The regex pattern for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.policy.init.delete(ctx, policy_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.policy.init.delete policy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="delete_policy",
        op_kwargs={"PolicyId": policy_id},
    )


async def describe(hub, ctx, policy_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a policy. This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an AWS service.

    Args:
        policy_id(str): The unique identifier (ID) of the policy that you want details about. You can get the ID from the ListPolicies or ListPoliciesForTarget operations. The regex pattern for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.policy.init.describe(ctx, policy_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.policy.init.describe policy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="describe_policy",
        op_kwargs={"PolicyId": policy_id},
    )


async def detach(hub, ctx, policy_id: str, target_id: str) -> None:
    r"""
    **Autogenerated function**

    Detaches a policy from a target root, organizational unit (OU), or account.  If the policy being detached is a service control policy (SCP), the changes to permissions for AWS Identity and Access Management (IAM) users and roles in affected accounts are immediate.  Every root, OU, and account must have at least one SCP attached. If you want to replace the default FullAWSAccess policy with an SCP that limits the permissions that can be delegated, you must attach the replacement SCP before you can remove the default SCP. This is the authorization strategy of an "allow list". If you instead attach a second SCP and leave the FullAWSAccess SCP still attached, and specify "Effect": "Deny" in the second SCP to override the "Effect": "Allow" in the FullAWSAccess policy (or any other attached SCP), you're using the authorization strategy of a "deny list". This operation can be called only from the organization's management account.

    Args:
        policy_id(str): The unique identifier (ID) of the policy you want to detach. You can get the ID from the ListPolicies or ListPoliciesForTarget operations. The regex pattern for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
        target_id(str): The unique identifier (ID) of the root, OU, or account that you want to detach the policy from. You can get the ID from the ListRoots, ListOrganizationalUnitsForParent, or ListAccounts operations. The regex pattern for a target ID string requires one of the following:    Root - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.    Account - A string that consists of exactly 12 digits.    Organizational unit (OU) - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.policy.init.detach(
                ctx, policy_id=value, target_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.policy.init.detach policy_id=value, target_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="detach_policy",
        op_kwargs={"PolicyId": policy_id, "TargetId": target_id},
    )


async def list_all(
    hub, ctx, filter_: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the list of all policies in an organization of a specified type.  Always check the NextToken response parameter for a null value when calling a List* operation. These operations can occasionally return an empty set of results even when there are more results available. The NextToken response parameter value is null only when there are no more results to display.  This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an AWS service.

    Args:
        filter_(str): Specifies the type of policy that you want to include in the response. You must specify one of the following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY     SERVICE_CONTROL_POLICY     TAG_POLICY   .
        next_token(str, optional): The parameter for receiving additional results if you receive a NextToken response in a previous request. A NextToken response indicates that more output is available. Set this parameter to the value of the previous call's NextToken response to indicate where the output should continue from. Defaults to None.
        max_results(int, optional): The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the NextToken response element is present and has a value (is not null). Include that value as the NextToken request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check NextToken after every operation to ensure that you receive all of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.policy.init.list_all(ctx, filter_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.policy.init.list_all filter_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="list_policies",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    policy_id: str,
    name: str = None,
    description: str = None,
    content: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing policy with a new name, description, or content. If you don't supply any parameter, that value remains unchanged. You can't change a policy's type. This operation can be called only from the organization's management account.

    Args:
        policy_id(str): The unique identifier (ID) of the policy that you want to update. The regex pattern for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
        name(str, optional): If provided, the new name for the policy. The regex pattern that is used to validate this parameter is a string of any of the characters in the ASCII character range. Defaults to None.
        description(str, optional): If provided, the new description for the policy. Defaults to None.
        content(str, optional): If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy's type. For more information, see Service Control Policy Syntax in the AWS Organizations User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.policy.init.update(ctx, policy_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.policy.init.update policy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="update_policy",
        op_kwargs={
            "PolicyId": policy_id,
            "Name": name,
            "Description": description,
            "Content": content,
        },
    )
