"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, parent_id: str, name: str, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an organizational unit (OU) within a root or parent OU. An OU is a container for accounts that enables you to organize your accounts to apply policies according to your business requirements. The number of levels deep that you can nest OUs is dependent upon the policy types enabled for that root. For service control policies, the limit is five. For more information about OUs, see Managing Organizational Units in the AWS Organizations User Guide.  If the request includes tags, then the requester must have the organizations:TagResource permission. This operation can be called only from the organization's management account.

    Args:
        parent_id(str): The unique identifier (ID) of the parent root or OU that you want to create the new OU in. The regex pattern for a parent ID string requires one of the following:    Root - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.    Organizational unit (OU) - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.  .
        name(str): The friendly name to assign to the new OU.
        tags(List, optional): A list of tags that you want to attach to the newly created OU. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can't set it to null. For more information about tagging, see Tagging AWS Organizations resources in the AWS Organizations User Guide.  If any one of the tags is invalid or if you exceed the allowed number of tags for an OU, then the entire request fails and the OU is not created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.organizational_unit.init.create(
                ctx, parent_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.organizational_unit.init.create parent_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="create_organizational_unit",
        op_kwargs={"ParentId": parent_id, "Name": name, "Tags": tags},
    )


async def delete(hub, ctx, organizational_unit_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an organizational unit (OU) from a root or another OU. You must first remove all accounts and child OUs from the OU that you want to delete. This operation can be called only from the organization's management account.

    Args:
        organizational_unit_id(str): The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from the ListOrganizationalUnitsForParent operation. The regex pattern for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.organizational_unit.init.delete(
                ctx, organizational_unit_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.organizational_unit.init.delete organizational_unit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="delete_organizational_unit",
        op_kwargs={"OrganizationalUnitId": organizational_unit_id},
    )


async def describe(hub, ctx, organizational_unit_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about an organizational unit (OU). This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an AWS service.

    Args:
        organizational_unit_id(str): The unique identifier (ID) of the organizational unit that you want details about. You can get the ID from the ListOrganizationalUnitsForParent operation. The regex pattern for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.organizational_unit.init.describe(
                ctx, organizational_unit_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.organizational_unit.init.describe organizational_unit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="describe_organizational_unit",
        op_kwargs={"OrganizationalUnitId": organizational_unit_id},
    )


async def update(hub, ctx, organizational_unit_id: str, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Renames the specified organizational unit (OU). The ID and ARN don't change. The child OUs and accounts remain in place, and any attached policies of the OU remain attached. This operation can be called only from the organization's management account.

    Args:
        organizational_unit_id(str): The unique identifier (ID) of the OU that you want to rename. You can get the ID from the ListOrganizationalUnitsForParent operation. The regex pattern for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.
        name(str, optional): The new name that you want to assign to the OU. The regex pattern that is used to validate this parameter is a string of any of the characters in the ASCII character range. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.organizational_unit.init.update(
                ctx, organizational_unit_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.organizational_unit.init.update organizational_unit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="update_organizational_unit",
        op_kwargs={"OrganizationalUnitId": organizational_unit_id, "Name": name},
    )
