"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, feature_set: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an AWS organization. The account whose user is calling the CreateOrganization operation automatically becomes the management account of the new organization. This operation must be called using credentials from the account that is to become the new organization's management account. The principal must also have the relevant IAM permissions. By default (or if you set the FeatureSet parameter to ALL), the new organization is created with all features enabled and service control policies automatically enabled in the root. If you instead choose to create the organization supporting only the consolidated billing features by setting the FeatureSet parameter to CONSOLIDATED_BILLING", no policy types are enabled by default, and you can't use organization policies

    Args:
        feature_set(str, optional): Specifies the feature set supported by the new organization. Each feature set supports different levels of functionality.    CONSOLIDATED_BILLING: All member accounts have their bills consolidated to and paid by the management account. For more information, see Consolidated billing in the AWS Organizations User Guide.   The consolidated billing feature subset isn't available for organizations in the AWS GovCloud (US) Region.    ALL: In addition to all the features supported by the consolidated billing feature set, the management account can also apply any policy type to any member account in the organization. For more information, see All features in the AWS Organizations User Guide.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.organization.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.organization.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="create_organization",
        op_kwargs={"FeatureSet": feature_set},
    )


async def delete(hub, ctx) -> None:
    r"""
    **Autogenerated function**

    Deletes the organization. You can delete an organization only by using credentials from the management account. The organization must be empty of member accounts.

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.organization.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.organization.delete
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="organizations", operation="delete_organization", op_kwargs={}
    )


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the organization that the user's account belongs to. This operation can be called from any account in the organization.  Even if a policy type is shown as available in the organization, you can disable it separately at the root level with DisablePolicyType. Use ListRoots to see the status of policy types for a specified root.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.organization.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.organization.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="describe_organization",
        op_kwargs={},
    )


async def leave(hub, ctx) -> None:
    r"""
    **Autogenerated function**

    Removes a member account from its parent organization. This version of the operation is performed by the account that wants to leave. To remove a member account as a user in the management account, use RemoveAccountFromOrganization instead. This operation can be called only from a member account in the organization.    The management account in an organization with all features enabled can set service control policies (SCPs) that can restrict what administrators of member accounts can do. This includes preventing them from successfully calling LeaveOrganization and leaving the organization.   You can leave an organization as a member account only if the account is configured with the information required to operate as a standalone account. When you create an account in an organization using the AWS Organizations console, API, or CLI commands, the information required of standalone accounts is not automatically collected. For each account that you want to make standalone, you must perform the following steps. If any of the steps are already completed for this account, that step doesn't appear.   Choose a support plan   Provide and verify the required contact information   Provide a current payment method   AWS uses the payment method to charge for any billable (not free tier) AWS activity that occurs while the account isn't attached to an organization. Follow the steps at  To leave an organization when all required account information has not yet been provided in the AWS Organizations User Guide.    The account that you want to leave must not be a delegated administrator account for any AWS service enabled for your organization. If the account is a delegated administrator, you must first change the delegated administrator account to another account that is remaining in the organization.   You can leave an organization only after you enable IAM user access to billing in your account. For more information, see Activating Access to the Billing and Cost Management Console in the AWS Billing and Cost Management User Guide.    After the account leaves the organization, all tags that were attached to the account object in the organization are deleted. AWS accounts outside of an organization do not support tags.   A newly created account has a waiting period before it can be removed from its organization. If you get an error that indicates that a wait period is required, then try again in a few days.

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.organization.leave(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.organization.leave
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="organizations", operation="leave_organization", op_kwargs={}
    )
