"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, policy_type: str, target_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the contents of the effective policy for specified policy type and account. The effective policy is the aggregation of any policies of the specified type that the account inherits, plus any policy of that type that is directly attached to the account. This operation applies only to policy types other than service control policies (SCPs). For more information about policy inheritance, see How Policy Inheritance Works in the AWS Organizations User Guide. This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an AWS service.

    Args:
        policy_type(str): The type of policy that you want information about. You can specify one of the following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY     TAG_POLICY   .
        target_id(str, optional): When you're signed in as the management account, specify the ID of the account that you want details about. Specifying an organization root or organizational unit (OU) as the target is not supported. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.effective_policy.describe(ctx, policy_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.effective_policy.describe policy_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="describe_effective_policy",
        op_kwargs={"PolicyType": policy_type, "TargetId": target_id},
    )
