"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(hub, ctx, account_id: str, service_principal: str) -> None:
    r"""
    **Autogenerated function**

    Removes the specified member AWS account as a delegated administrator for the specified AWS service.  Deregistering a delegated administrator can have unintended impacts on the functionality of the enabled AWS service. See the documentation for the enabled service before you deregister a delegated administrator so that you understand any potential impacts.  You can run this action only for AWS services that support this feature. For a current list of services that support it, see the column Supports Delegated Administrator in the table at AWS Services that you can use with AWS Organizations in the AWS Organizations User Guide.  This operation can be called only from the organization's management account.

    Args:
        account_id(str): The account ID number of the member account in the organization that you want to deregister as a delegated administrator.
        service_principal(str): The service principal name of an AWS service for which the account is a delegated administrator. Delegated administrator privileges are revoked for only the specified AWS service from the member account. If the specified service is the only service for which the member account is a delegated administrator, the operation also revokes Organizations read action permissions.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.delegated.administrator.deregister(
                ctx, account_id=value, service_principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.delegated.administrator.deregister account_id=value, service_principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="deregister_delegated_administrator",
        op_kwargs={"AccountId": account_id, "ServicePrincipal": service_principal},
    )


async def list_all(
    hub,
    ctx,
    service_principal: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the AWS accounts that are designated as delegated administrators in this organization. This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an AWS service.

    Args:
        service_principal(str, optional): Specifies a service principal name. If specified, then the operation lists the delegated administrators only for the specified service. If you don't specify a service principal, the operation lists all delegated administrators for all services in your organization. Defaults to None.
        next_token(str, optional): The parameter for receiving additional results if you receive a NextToken response in a previous request. A NextToken response indicates that more output is available. Set this parameter to the value of the previous call's NextToken response to indicate where the output should continue from. Defaults to None.
        max_results(int, optional): The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the NextToken response element is present and has a value (is not null). Include that value as the NextToken request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check NextToken after every operation to ensure that you receive all of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.delegated.administrator.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.delegated.administrator.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="list_delegated_administrators",
        op_kwargs={
            "ServicePrincipal": service_principal,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def register(hub, ctx, account_id: str, service_principal: str) -> None:
    r"""
    **Autogenerated function**

    Enables the specified member account to administer the Organizations features of the specified AWS service. It grants read-only access to AWS Organizations service data. The account still requires IAM permissions to access and administer the AWS service. You can run this action only for AWS services that support this feature. For a current list of services that support it, see the column Supports Delegated Administrator in the table at AWS Services that you can use with AWS Organizations in the AWS Organizations User Guide.  This operation can be called only from the organization's management account.

    Args:
        account_id(str): The account ID number of the member account in the organization to register as a delegated administrator.
        service_principal(str): The service principal of the AWS service for which you want to make the member account a delegated administrator.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.delegated.administrator.register(
                ctx, account_id=value, service_principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.delegated.administrator.register account_id=value, service_principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="register_delegated_administrator",
        op_kwargs={"AccountId": account_id, "ServicePrincipal": service_principal},
    )
