"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def describe(hub, ctx, create_account_request_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current status of an asynchronous request to create an account. This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an AWS service.

    Args:
        create_account_request_id(str): Specifies the Id value that uniquely identifies the CreateAccount request. You can get the value from the CreateAccountStatus.Id response in an earlier CreateAccount request, or from the ListCreateAccountStatus operation. The regex pattern for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.create_account_status.describe(
                ctx, create_account_request_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.create_account_status.describe create_account_request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="describe_create_account_status",
        op_kwargs={"CreateAccountRequestId": create_account_request_id},
    )


async def list_(
    hub, ctx, states: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the account creation requests that match the specified status that is currently being tracked for the organization.  Always check the NextToken response parameter for a null value when calling a List* operation. These operations can occasionally return an empty set of results even when there are more results available. The NextToken response parameter value is null only when there are no more results to display.  This operation can be called only from the organization's management account or by a member account that is a delegated administrator for an AWS service.

    Args:
        states(List, optional): A list of one or more states that you want included in the response. If this parameter isn't present, all requests are included in the response. Defaults to None.
        next_token(str, optional): The parameter for receiving additional results if you receive a NextToken response in a previous request. A NextToken response indicates that more output is available. Set this parameter to the value of the previous call's NextToken response to indicate where the output should continue from. Defaults to None.
        max_results(int, optional): The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the NextToken response element is present and has a value (is not null). Include that value as the NextToken request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check NextToken after every operation to ensure that you receive all of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.create_account_status.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.create_account_status.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="list_create_account_status",
        op_kwargs={
            "States": states,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
