"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def disable(hub, ctx, service_principal: str) -> None:
    r"""
    **Autogenerated function**

    Disables the integration of an AWS service (the service that is specified by ServicePrincipal) with AWS Organizations. When you disable integration, the specified service no longer can create a service-linked role in new accounts in your organization. This means the service can't perform operations on your behalf on any new accounts in your organization. The service can still perform operations in older accounts until the service completes its clean-up from AWS Organizations.  We  strongly recommend  that you don't use this command to disable integration between AWS Organizations and the specified AWS service. Instead, use the console or commands that are provided by the specified service. This lets the trusted service perform any required initialization when enabling trusted access, such as creating any required resources and any required clean up of resources when disabling trusted access.  For information about how to disable trusted service access to your organization using the trusted service, see the Learn more link under the Supports Trusted Access column at AWS services that you can use with AWS Organizations. on this page. If you disable access by using this command, it causes the following actions to occur:   The service can no longer create a service-linked role in the accounts in your organization. This means that the service can't perform operations on your behalf on any new accounts in your organization. The service can still perform operations in older accounts until the service completes its clean-up from AWS Organizations.    The service can no longer perform tasks in the member accounts in the organization, unless those operations are explicitly permitted by the IAM policies that are attached to your roles. This includes any data aggregation from the member accounts to the management account, or to a delegated administrator account, where relevant.   Some services detect this and clean up any remaining data or resources related to the integration, while other services stop accessing the organization but leave any historical data and configuration in place to support a possible re-enabling of the integration.   Using the other service's console or commands to disable the integration ensures that the other service is aware that it can clean up any resources that are required only for the integration. How the service cleans up its resources in the organization's accounts depends on that service. For more information, see the documentation for the other AWS service.   After you perform the DisableAWSServiceAccess operation, the specified service can no longer perform operations in your organization's accounts  For more information about integrating other services with AWS Organizations, including the list of services that work with Organizations, see Integrating AWS Organizations with Other AWS Services in the AWS Organizations User Guide.  This operation can be called only from the organization's management account.

    Args:
        service_principal(str): The service principal name of the AWS service for which you want to disable integration with your organization. This is typically in the form of a URL, such as  service-abbreviation.amazonaws.com.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.aws_service_access.init.disable(
                ctx, service_principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.aws_service_access.init.disable service_principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="disable_aws_service_access",
        op_kwargs={"ServicePrincipal": service_principal},
    )


async def enable(hub, ctx, service_principal: str) -> None:
    r"""
    **Autogenerated function**

    Enables the integration of an AWS service (the service that is specified by ServicePrincipal) with AWS Organizations. When you enable integration, you allow the specified service to create a service-linked role in all the accounts in your organization. This allows the service to perform operations on your behalf in your organization and its accounts.  We recommend that you enable integration between AWS Organizations and the specified AWS service by using the console or commands that are provided by the specified service. Doing so ensures that the service is aware that it can create the resources that are required for the integration. How the service creates those resources in the organization's accounts depends on that service. For more information, see the documentation for the other AWS service.  For more information about enabling services to integrate with AWS Organizations, see Integrating AWS Organizations with Other AWS Services in the AWS Organizations User Guide.  This operation can be called only from the organization's management account and only if the organization has enabled all features.

    Args:
        service_principal(str): The service principal name of the AWS service for which you want to enable integration with your organization. This is typically in the form of a URL, such as  service-abbreviation.amazonaws.com.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.aws_service_access.init.enable(
                ctx, service_principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.aws_service_access.init.enable service_principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="enable_aws_service_access",
        op_kwargs={"ServicePrincipal": service_principal},
    )
