"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def remove(hub, ctx, account_id: str) -> None:
    r"""
    **Autogenerated function**

    Removes the specified account from the organization. The removed account becomes a standalone account that isn't a member of any organization. It's no longer subject to any policies and is responsible for its own bill payments. The organization's management account is no longer charged for any expenses accrued by the member account after it's removed from the organization. This operation can be called only from the organization's management account. Member accounts can remove themselves with LeaveOrganization instead.    You can remove an account from your organization only if the account is configured with the information required to operate as a standalone account. When you create an account in an organization using the AWS Organizations console, API, or CLI commands, the information required of standalone accounts is not automatically collected. For an account that you want to make standalone, you must choose a support plan, provide and verify the required contact information, and provide a current payment method. AWS uses the payment method to charge for any billable (not free tier) AWS activity that occurs while the account isn't attached to an organization. To remove an account that doesn't yet have this information, you must sign in as the member account and follow the steps at  To leave an organization when all required account information has not yet been provided in the AWS Organizations User Guide.    The account that you want to leave must not be a delegated administrator account for any AWS service enabled for your organization. If the account is a delegated administrator, you must first change the delegated administrator account to another account that is remaining in the organization.   After the account leaves the organization, all tags that were attached to the account object in the organization are deleted. AWS accounts outside of an organization do not support tags.

    Args:
        account_id(str): The unique identifier (ID) of the member account that you want to remove from the organization. The regex pattern for an account ID string requires exactly 12 digits.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.organization.account.from_organization.remove(
                ctx, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.organization.account.from_organization.remove account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="organizations",
        operation="remove_account_from_organization",
        op_kwargs={"AccountId": account_id},
    )
