"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    engine: str,
    server_name: str,
    instance_profile_arn: str,
    instance_type: str,
    service_role_arn: str,
    associate_public_ip_address: bool = None,
    custom_domain: str = None,
    custom_certificate: str = None,
    custom_private_key: str = None,
    disable_automated_backup: bool = None,
    engine_model: str = None,
    engine_version: str = None,
    engine_attributes: List = None,
    backup_retention_count: int = None,
    key_pair: str = None,
    preferred_maintenance_window: str = None,
    preferred_backup_window: str = None,
    security_group_ids: List = None,
    subnet_ids: List = None,
    tags: List = None,
    backup_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates and immedately starts a new server. The server is ready to use when it is in the HEALTHY state. By default, you can create a maximum of 10 servers.   This operation is asynchronous.   A LimitExceededException is thrown when you have created the maximum number of servers (10). A ResourceAlreadyExistsException is thrown when a server with the same name already exists in the account. A ResourceNotFoundException is thrown when you specify a backup ID that is not valid or is for a backup that does not exist. A ValidationException is thrown when parameters of the request are not valid.   If you do not specify a security group by adding the SecurityGroupIds parameter, AWS OpsWorks creates a new security group.   Chef Automate: The default security group opens the Chef server to the world on TCP port 443. If a KeyName is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.   Puppet Enterprise: The default security group opens TCP ports 22, 443, 4433, 8140, 8142, 8143, and 8170. If a KeyName is present, AWS OpsWorks enables SSH access. SSH is also open to the world on TCP port 22.  By default, your server is accessible from any IP address. We recommend that you update your security group rules to allow access from known IP addresses and address ranges only. To edit security group rules, open Security Groups in the navigation pane of the EC2 management console.  To specify your own domain for a server, and provide your own self-signed or CA-signed certificate and private key, specify values for CustomDomain, CustomCertificate, and CustomPrivateKey.

    Args:
        associate_public_ip_address(bool, optional):  Associate a public IP address with a server that you are launching. Valid values are true or false. The default value is true. . Defaults to None.
        custom_domain(str, optional): An optional public endpoint of a server, such as https://aws.my-company.com. To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated Endpoint value if the server is using a custom domain. If you specify a custom domain, you must also specify values for CustomCertificate and CustomPrivateKey. Defaults to None.
        custom_certificate(str, optional): A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for CustomDomain and CustomPrivateKey. The following are requirements for the CustomCertificate value:   You can provide either a self-signed, custom certificate, or the full certificate chain.   The certificate must be a valid X509 certificate, or a certificate chain in PEM format.   The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's NotBefore date), or after it expires (the certificate's NotAfter date).   The certificate’s common name or subject alternative names (SANs), if present, must match the value of CustomDomain.   The certificate must match the value of CustomPrivateKey.  . Defaults to None.
        custom_private_key(str, optional): A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for CustomDomain and CustomCertificate. Defaults to None.
        disable_automated_backup(bool, optional):  Enable or disable scheduled backups. Valid values are true or false. The default value is true. . Defaults to None.
        engine(str):  The configuration management engine to use. Valid values include ChefAutomate and Puppet. .
        engine_model(str, optional):  The engine model of the server. Valid values in this release include Monolithic for Puppet and Single for Chef. . Defaults to None.
        engine_version(str, optional):  The major release version of the engine that you want to use. For a Chef server, the valid value for EngineVersion is currently 2. For a Puppet server, valid values are 2019 or 2017. . Defaults to None.
        engine_attributes(List, optional): Optional engine attributes on a specified server.   Attributes accepted in a Chef createServer request:     CHEF_AUTOMATE_PIVOTAL_KEY: A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response.     CHEF_AUTOMATE_ADMIN_PASSWORD: The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/@#$%^&+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.    Attributes accepted in a Puppet createServer request:     PUPPET_ADMIN_PASSWORD: To work with the Puppet Enterprise console, a password must use ASCII characters.    PUPPET_R10K_REMOTE: The r10k remote is the URL of your control repository (for example, ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.    PUPPET_R10K_PRIVATE_KEY: If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.  . Defaults to None.
        backup_retention_count(int, optional):  The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is 1. . Defaults to None.
        server_name(str):  The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters. .
        instance_profile_arn(str):  The ARN of the instance profile that your Amazon EC2 instances use. Although the AWS OpsWorks console typically creates the instance profile for you, if you are using API commands instead, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the instance profile you need. .
        instance_type(str):  The Amazon EC2 instance type to use. For example, m5.large. .
        key_pair(str, optional):  The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH. . Defaults to None.
        preferred_maintenance_window(str, optional):  The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance. Valid values must be specified in the following format: DDD:HH:MM. MM must be specified as 00. The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See TimeWindowDefinition for more information.   Example: Mon:08:00, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.) . Defaults to None.
        preferred_backup_window(str, optional):  The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled. Valid values must be specified in one of the following formats:     HH:MM for daily backups    DDD:HH:MM for weekly backups    MM must be specified as 00. The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.  Example: 08:00, which represents a daily start time of 08:00 UTC.  Example: Mon:08:00, which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.). Defaults to None.
        security_group_ids(List, optional):  A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified security groups must be within the VPC that is specified by SubnetIds.   If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone). . Defaults to None.
        service_role_arn(str):  The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need. .
        subnet_ids(List, optional):  The IDs of subnets in which to launch the server EC2 instance.   Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.   EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.  For more information about supported Amazon EC2 platforms, see Supported Platforms. Defaults to None.
        tags(List, optional): A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server.   The key cannot be empty.   The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: + - = . _ : / @    The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: + - = . _ : / @    Leading and trailing white spaces are trimmed from both the key and value.   A maximum of 50 user-applied tags is allowed for any AWS OpsWorks-CM server.  . Defaults to None.
        backup_id(str, optional):  If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.server.init.create(
                ctx,
                engine=value,
                server_name=value,
                instance_profile_arn=value,
                instance_type=value,
                service_role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.server.init.create engine=value, server_name=value, instance_profile_arn=value, instance_type=value, service_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="create_server",
        op_kwargs={
            "AssociatePublicIpAddress": associate_public_ip_address,
            "CustomDomain": custom_domain,
            "CustomCertificate": custom_certificate,
            "CustomPrivateKey": custom_private_key,
            "DisableAutomatedBackup": disable_automated_backup,
            "Engine": engine,
            "EngineModel": engine_model,
            "EngineVersion": engine_version,
            "EngineAttributes": engine_attributes,
            "BackupRetentionCount": backup_retention_count,
            "ServerName": server_name,
            "InstanceProfileArn": instance_profile_arn,
            "InstanceType": instance_type,
            "KeyPair": key_pair,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "PreferredBackupWindow": preferred_backup_window,
            "SecurityGroupIds": security_group_ids,
            "ServiceRoleArn": service_role_arn,
            "SubnetIds": subnet_ids,
            "Tags": tags,
            "BackupId": backup_id,
        },
    )


async def delete(hub, ctx, server_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes the server and the underlying AWS CloudFormation stacks (including the server's EC2 instance). When you run this command, the server state is updated to DELETING. After the server is deleted, it is no longer returned by DescribeServer requests. If the AWS CloudFormation stack cannot be deleted, the server cannot be deleted.   This operation is asynchronous.   An InvalidStateException is thrown when a server deletion is already in progress. A ResourceNotFoundException is thrown when the server does not exist. A ValidationException is raised when parameters of the request are not valid.

    Args:
        server_name(str): The ID of the server to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.server.init.delete(ctx, server_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.server.init.delete server_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="delete_server",
        op_kwargs={"ServerName": server_name},
    )


async def describe_all(
    hub, ctx, server_name: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Lists all configuration management servers that are identified with your account. Only the stored results from Amazon DynamoDB are returned. AWS OpsWorks CM does not query other services.   This operation is synchronous.   A ResourceNotFoundException is thrown when the server does not exist. A ValidationException is raised when parameters of the request are not valid.

    Args:
        server_name(str, optional): Describes the server with the specified ServerName. Defaults to None.
        next_token(str, optional): This is not currently implemented for DescribeServers requests. . Defaults to None.
        max_results(int, optional): This is not currently implemented for DescribeServers requests. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.server.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.server.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="describe_servers",
        op_kwargs={
            "ServerName": server_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def restore(
    hub,
    ctx,
    backup_id: str,
    server_name: str,
    instance_type: str = None,
    key_pair: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Restores a backup to a server that is in a CONNECTION_LOST, HEALTHY, RUNNING, UNHEALTHY, or TERMINATED state. When you run RestoreServer, the server's EC2 instance is deleted, and a new EC2 instance is configured. RestoreServer maintains the existing server endpoint, so configuration management of the server's client devices (nodes) should continue to work.  Restoring from a backup is performed by creating a new EC2 instance. If restoration is successful, and the server is in a HEALTHY state, AWS OpsWorks CM switches traffic over to the new instance. After restoration is finished, the old EC2 instance is maintained in a Running or Stopped state, but is eventually terminated.  This operation is asynchronous.   An InvalidStateException is thrown when the server is not in a valid state. A ResourceNotFoundException is thrown when the server does not exist. A ValidationException is raised when parameters of the request are not valid.

    Args:
        backup_id(str):  The ID of the backup that you want to use to restore a server. .
        server_name(str):  The name of the server that you want to restore. .
        instance_type(str, optional):  The type of instance to restore. Valid values must be specified in the following format: ^([cm][34]|t2).* For example, m5.large. Valid values are m5.large, r5.xlarge, and r5.2xlarge. If you do not specify this parameter, RestoreServer uses the instance type from the specified backup. . Defaults to None.
        key_pair(str, optional):  The name of the key pair to set on the new EC2 instance. This can be helpful if the administrator no longer has the SSH key. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.server.init.restore(
                ctx, backup_id=value, server_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.server.init.restore backup_id=value, server_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="restore_server",
        op_kwargs={
            "BackupId": backup_id,
            "ServerName": server_name,
            "InstanceType": instance_type,
            "KeyPair": key_pair,
        },
    )


async def update(
    hub,
    ctx,
    server_name: str,
    disable_automated_backup: bool = None,
    backup_retention_count: int = None,
    preferred_maintenance_window: str = None,
    preferred_backup_window: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates settings for a server.   This operation is synchronous.

    Args:
        disable_automated_backup(bool, optional): Setting DisableAutomatedBackup to true disables automated or scheduled backups. Automated backups are enabled by default. . Defaults to None.
        backup_retention_count(int, optional): Sets the number of automated backups that you want to keep. . Defaults to None.
        server_name(str): The name of the server to update. .
        preferred_maintenance_window(str, optional):  DDD:HH:MM (weekly start time) or HH:MM (daily start time).   Time windows always use coordinated universal time (UTC). Valid strings for day of week (DDD) are: Mon, Tue, Wed, Thr, Fri, Sat, or Sun. Defaults to None.
        preferred_backup_window(str, optional):  DDD:HH:MM (weekly start time) or HH:MM (daily start time).   Time windows always use coordinated universal time (UTC). Valid strings for day of week (DDD) are: Mon, Tue, Wed, Thr, Fri, Sat, or Sun. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.server.init.update(ctx, server_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.server.init.update server_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="update_server",
        op_kwargs={
            "DisableAutomatedBackup": disable_automated_backup,
            "BackupRetentionCount": backup_retention_count,
            "ServerName": server_name,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "PreferredBackupWindow": preferred_backup_window,
        },
    )
