"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def export(
    hub,
    ctx,
    export_attribute_name: str,
    server_name: str,
    input_attributes: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Exports a specified server engine attribute as a base64-encoded string. For example, you can export user data that you can use in EC2 to associate nodes with a server.   This operation is synchronous.   A ValidationException is raised when parameters of the request are not valid. A ResourceNotFoundException is thrown when the server does not exist. An InvalidStateException is thrown when the server is in any of the following states: CREATING, TERMINATED, FAILED or DELETING.

    Args:
        export_attribute_name(str): The name of the export attribute. Currently, the supported export attribute is Userdata. This exports a user data script that includes parameters and values provided in the InputAttributes list.
        server_name(str): The name of the server from which you are exporting the attribute.
        input_attributes(List, optional): The list of engine attributes. The list type is EngineAttribute. An EngineAttribute list item is a pair that includes an attribute name and its value. For the Userdata ExportAttributeName, the following are supported engine attribute names.    RunList In Chef, a list of roles or recipes that are run in the specified order. In Puppet, this parameter is ignored.    OrganizationName In Chef, an organization name. AWS OpsWorks for Chef Automate always creates the organization default. In Puppet, this parameter is ignored.    NodeEnvironment In Chef, a node environment (for example, development, staging, or one-box). In Puppet, this parameter is ignored.    NodeClientVersion In Chef, the version of the Chef engine (three numbers separated by dots, such as 13.8.5). If this attribute is empty, OpsWorks for Chef Automate uses the most current version. In Puppet, this parameter is ignored.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.server.engine_attribute.export(
                ctx, export_attribute_name=value, server_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.server.engine_attribute.export export_attribute_name=value, server_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="export_server_engine_attribute",
        op_kwargs={
            "ExportAttributeName": export_attribute_name,
            "ServerName": server_name,
            "InputAttributes": input_attributes,
        },
    )


async def update_multiple(
    hub, ctx, server_name: str, attribute_name: str, attribute_value: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Updates engine-specific attributes on a specified server. The server enters the MODIFYING state when this operation is in progress. Only one update can occur at a time. You can use this command to reset a Chef server's public key (CHEF_PIVOTAL_KEY) or a Puppet server's admin password (PUPPET_ADMIN_PASSWORD).   This operation is asynchronous.   This operation can only be called for servers in HEALTHY or UNHEALTHY states. Otherwise, an InvalidStateException is raised. A ResourceNotFoundException is thrown when the server does not exist. A ValidationException is raised when parameters of the request are not valid.

    Args:
        server_name(str): The name of the server to update. .
        attribute_name(str): The name of the engine attribute to update. .
        attribute_value(str, optional): The value to set for the attribute. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.server.engine_attribute.update_multiple(
                ctx, server_name=value, attribute_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.server.engine_attribute.update_multiple server_name=value, attribute_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="update_server_engine_attributes",
        op_kwargs={
            "ServerName": server_name,
            "AttributeName": attribute_name,
            "AttributeValue": attribute_value,
        },
    )
