"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, server_name: str, node_name: str, engine_attributes: List
) -> Dict:
    r"""
    **Autogenerated function**

     Associates a new node with the server. For more information about how to disassociate a node, see DisassociateNode.  On a Chef server: This command is an alternative to knife bootstrap.  Example (Chef): aws opsworks-cm associate-node --server-name MyServer --node-name MyManagedNode --engine-attributes "Name=CHEF_ORGANIZATION,Value=default" "Name=CHEF_NODE_PUBLIC_KEY,Value=public-key-pem"   On a Puppet server, this command is an alternative to the puppet cert sign command that signs a Puppet node CSR.   Example (Puppet): aws opsworks-cm associate-node --server-name MyServer --node-name MyManagedNode --engine-attributes "Name=PUPPET_NODE_CSR,Value=csr-pem"   A node can can only be associated with servers that are in a HEALTHY state. Otherwise, an InvalidStateException is thrown. A ResourceNotFoundException is thrown when the server does not exist. A ValidationException is raised when parameters of the request are not valid. The AssociateNode API call can be integrated into Auto Scaling configurations, AWS Cloudformation templates, or the user data of a server's instance.

    Args:
        server_name(str): The name of the server with which to associate the node. .
        node_name(str): The name of the node. .
        engine_attributes(List): Engine attributes used for associating the node.   Attributes accepted in a AssociateNode request for Chef     CHEF_ORGANIZATION: The Chef organization with which the node is associated. By default only one organization named default can exist.     CHEF_NODE_PUBLIC_KEY: A PEM-formatted public key. This key is required for the chef-client agent to access the Chef API.     Attributes accepted in a AssociateNode request for Puppet     PUPPET_NODE_CSR: A PEM-formatted certificate-signing request (CSR) that is created by the node.   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.node.init.associate(
                ctx, server_name=value, node_name=value, engine_attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.node.init.associate server_name=value, node_name=value, engine_attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="associate_node",
        op_kwargs={
            "ServerName": server_name,
            "NodeName": node_name,
            "EngineAttributes": engine_attributes,
        },
    )


async def disassociate(
    hub, ctx, server_name: str, node_name: str, engine_attributes: List = None
) -> Dict:
    r"""
    **Autogenerated function**

     Disassociates a node from an AWS OpsWorks CM server, and removes the node from the server's managed nodes. After a node is disassociated, the node key pair is no longer valid for accessing the configuration manager's API. For more information about how to associate a node, see AssociateNode.  A node can can only be disassociated from a server that is in a HEALTHY state. Otherwise, an InvalidStateException is thrown. A ResourceNotFoundException is thrown when the server does not exist. A ValidationException is raised when parameters of the request are not valid.

    Args:
        server_name(str): The name of the server from which to disassociate the node. .
        node_name(str): The name of the client node. .
        engine_attributes(List, optional): Engine attributes that are used for disassociating the node. No attributes are required for Puppet.   Attributes required in a DisassociateNode request for Chef     CHEF_ORGANIZATION: The Chef organization with which the node was associated. By default only one organization named default can exist.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.node.init.disassociate(
                ctx, server_name=value, node_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.node.init.disassociate server_name=value, node_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="disassociate_node",
        op_kwargs={
            "ServerName": server_name,
            "NodeName": node_name,
            "EngineAttributes": engine_attributes,
        },
    )
