"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, node_association_status_token: str, server_name: str
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the current status of an existing association or disassociation request.   A ResourceNotFoundException is thrown when no recent association or disassociation request with the specified token is found, or when the server does not exist. A ValidationException is raised when parameters of the request are not valid.

    Args:
        node_association_status_token(str): The token returned in either the AssociateNodeResponse or the DisassociateNodeResponse. .
        server_name(str): The name of the server from which to disassociate the node. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.node.association_status.describe(
                ctx, node_association_status_token=value, server_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.node.association_status.describe node_association_status_token=value, server_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="describe_node_association_status",
        op_kwargs={
            "NodeAssociationStatusToken": node_association_status_token,
            "ServerName": server_name,
        },
    )
