"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, server_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Describes events for a specified server. Results are ordered by time, with newest events first.   This operation is synchronous.   A ResourceNotFoundException is thrown when the server does not exist. A ValidationException is raised when parameters of the request are not valid.

    Args:
        server_name(str): The name of the server for which you want to view events.
        next_token(str, optional): NextToken is a string that is returned in some command responses. It indicates that not all entries have been returned, and that you must run at least one more request to get remaining items. To get remaining results, call DescribeEvents again, and assign the token from the previous results as the value of the nextToken parameter. If there are no more results, the response object's nextToken parameter value is null. Setting a nextToken value that was not returned in your previous results causes an InvalidNextTokenException to occur. . Defaults to None.
        max_results(int, optional): To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a NextToken value that you can assign to the NextToken request parameter to get the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.event.describe_all(ctx, server_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.event.describe_all server_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="describe_events",
        op_kwargs={
            "ServerName": server_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
