"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, server_name: str, description: str = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

     Creates an application-level backup of a server. While the server is in the BACKING_UP state, the server cannot be changed, and no additional backup can be created.   Backups can be created for servers in RUNNING, HEALTHY, and UNHEALTHY states. By default, you can create a maximum of 50 manual backups.   This operation is asynchronous.   A LimitExceededException is thrown when the maximum number of manual backups is reached. An InvalidStateException is thrown when the server is not in any of the following states: RUNNING, HEALTHY, or UNHEALTHY. A ResourceNotFoundException is thrown when the server is not found. A ValidationException is thrown when parameters of the request are not valid.

    Args:
        server_name(str): The name of the server that you want to back up. .
        description(str, optional):  A user-defined description of the backup. . Defaults to None.
        tags(List, optional): A map that contains tag keys and tag values to attach to an AWS OpsWorks-CM server backup.   The key cannot be empty.   The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: + - = . _ : /    The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: + - = . _ : /    Leading and trailing white spaces are trimmed from both the key and value.   A maximum of 50 user-applied tags is allowed for tag-supported AWS OpsWorks-CM resources.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.backup.create(ctx, server_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.backup.create server_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="create_backup",
        op_kwargs={"ServerName": server_name, "Description": description, "Tags": tags},
    )


async def delete(hub, ctx, backup_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a backup. You can delete both manual and automated backups. This operation is asynchronous.   An InvalidStateException is thrown when a backup deletion is already in progress. A ResourceNotFoundException is thrown when the backup does not exist. A ValidationException is thrown when parameters of the request are not valid.

    Args:
        backup_id(str): The ID of the backup to delete. Run the DescribeBackups command to get a list of backup IDs. Backup IDs are in the format ServerName-yyyyMMddHHmmssSSS. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.backup.delete(ctx, backup_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.backup.delete backup_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="delete_backup",
        op_kwargs={"BackupId": backup_id},
    )


async def describe_all(
    hub,
    ctx,
    backup_id: str = None,
    server_name: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Describes backups. The results are ordered by time, with newest backups first. If you do not specify a BackupId or ServerName, the command returns all backups.   This operation is synchronous.   A ResourceNotFoundException is thrown when the backup does not exist. A ValidationException is raised when parameters of the request are not valid.

    Args:
        backup_id(str, optional): Describes a single backup. . Defaults to None.
        server_name(str, optional): Returns backups for the server with the specified ServerName. . Defaults to None.
        next_token(str, optional): This is not currently implemented for DescribeBackups requests. Defaults to None.
        max_results(int, optional): This is not currently implemented for DescribeBackups requests. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opsworkscm.backup.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opsworkscm.backup.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworkscm",
        operation="describe_backups",
        op_kwargs={
            "BackupId": backup_id,
            "ServerName": server_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
