"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def assign(hub, ctx, volume_id: str, instance_id: str = None) -> None:
    r"""
    **Autogenerated function**

    Assigns one of the stack's registered Amazon EBS volumes to a specified instance. The volume must first be registered with the stack by calling RegisterVolume. After you register the volume, you must call UpdateVolume to specify a mount point before calling AssignVolume. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        volume_id(str): The volume ID.
        instance_id(str, optional): The instance ID. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.volume.assign(ctx, volume_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.volume.assign volume_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="assign_volume",
        op_kwargs={"VolumeId": volume_id, "InstanceId": instance_id},
    )


async def deregister(hub, ctx, volume_id: str) -> None:
    r"""
    **Autogenerated function**

    Deregisters an Amazon EBS volume. The volume can then be registered by another stack. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        volume_id(str): The AWS OpsWorks Stacks volume ID, which is the GUID that AWS OpsWorks Stacks assigned to the instance when you registered the volume with the stack, not the Amazon EC2 volume ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.volume.deregister(ctx, volume_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.volume.deregister volume_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="deregister_volume",
        op_kwargs={"VolumeId": volume_id},
    )


async def describe_all(
    hub,
    ctx,
    instance_id: str = None,
    stack_id: str = None,
    raid_array_id: str = None,
    volume_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes an instance's Amazon EBS volumes.  This call accepts only one resource-identifying parameter.   Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        instance_id(str, optional): The instance ID. If you use this parameter, DescribeVolumes returns descriptions of the volumes associated with the specified instance. Defaults to None.
        stack_id(str, optional): A stack ID. The action describes the stack's registered Amazon EBS volumes. Defaults to None.
        raid_array_id(str, optional): The RAID array ID. If you use this parameter, DescribeVolumes returns descriptions of the volumes associated with the specified RAID array. Defaults to None.
        volume_ids(List, optional): Am array of volume IDs. If you use this parameter, DescribeVolumes returns descriptions of the specified volumes. Otherwise, it returns a description of every volume. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.volume.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.volume.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_volumes",
        op_kwargs={
            "InstanceId": instance_id,
            "StackId": stack_id,
            "RaidArrayId": raid_array_id,
            "VolumeIds": volume_ids,
        },
    )


async def register(hub, ctx, stack_id: str, ec2_volume_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Registers an Amazon EBS volume with a specified stack. A volume can be registered with only one stack at a time. If the volume is already registered, you must first deregister it by calling DeregisterVolume. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        ec2_volume_id(str, optional): The Amazon EBS volume ID. Defaults to None.
        stack_id(str): The stack ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.volume.register(ctx, stack_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.volume.register stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="register_volume",
        op_kwargs={"Ec2VolumeId": ec2_volume_id, "StackId": stack_id},
    )


async def unassign(hub, ctx, volume_id: str) -> None:
    r"""
    **Autogenerated function**

    Unassigns an assigned Amazon EBS volume. The volume remains registered with the stack. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        volume_id(str): The volume ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.volume.unassign(ctx, volume_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.volume.unassign volume_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="unassign_volume",
        op_kwargs={"VolumeId": volume_id},
    )


async def update(
    hub, ctx, volume_id: str, name: str = None, mount_point: str = None
) -> None:
    r"""
    **Autogenerated function**

    Updates an Amazon EBS volume's name or mount point. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        volume_id(str): The volume ID.
        name(str, optional): The new name. Defaults to None.
        mount_point(str, optional): The new mount point. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.volume.update(ctx, volume_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.volume.update volume_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="update_volume",
        op_kwargs={"VolumeId": volume_id, "Name": name, "MountPoint": mount_point},
    )
