"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    iam_user_arn: str,
    ssh_username: str = None,
    ssh_public_key: str = None,
    allow_self_management: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new user profile.  Required Permissions: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        iam_user_arn(str): The user's IAM ARN; this can also be a federated user's ARN.
        ssh_username(str, optional): The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, my.name will be changed to myname. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. . Defaults to None.
        ssh_public_key(str, optional): The user's public SSH key. Defaults to None.
        allow_self_management(bool, optional): Whether users can specify their own SSH public key through the My Settings page. For more information, see Setting an IAM User's Public SSH Key. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.user_profile.create(ctx, iam_user_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.user_profile.create iam_user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="create_user_profile",
        op_kwargs={
            "IamUserArn": iam_user_arn,
            "SshUsername": ssh_username,
            "SshPublicKey": ssh_public_key,
            "AllowSelfManagement": allow_self_management,
        },
    )


async def delete(hub, ctx, iam_user_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a user profile.  Required Permissions: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        iam_user_arn(str): The user's IAM ARN. This can also be a federated user's ARN.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.user_profile.delete(ctx, iam_user_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.user_profile.delete iam_user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="delete_user_profile",
        op_kwargs={"IamUserArn": iam_user_arn},
    )


async def describe_all(hub, ctx, iam_user_arns: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Describe specified users.  Required Permissions: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        iam_user_arns(List, optional): An array of IAM or federated user ARNs that identify the users to be described. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.user_profile.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.user_profile.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_user_profiles",
        op_kwargs={"IamUserArns": iam_user_arns},
    )


async def update(
    hub,
    ctx,
    iam_user_arn: str,
    ssh_username: str = None,
    ssh_public_key: str = None,
    allow_self_management: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates a specified user profile.  Required Permissions: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        iam_user_arn(str): The user IAM ARN. This can also be a federated user's ARN.
        ssh_username(str, optional): The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9], '-', and '_'. If the specified name includes other punctuation marks, AWS OpsWorks Stacks removes them. For example, my.name will be changed to myname. If you do not specify an SSH user name, AWS OpsWorks Stacks generates one from the IAM user name. . Defaults to None.
        ssh_public_key(str, optional): The user's new SSH public key. Defaults to None.
        allow_self_management(bool, optional): Whether users can specify their own SSH public key through the My Settings page. For more information, see Managing User Permissions. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.user_profile.update(ctx, iam_user_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.user_profile.update iam_user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="update_user_profile",
        op_kwargs={
            "IamUserArn": iam_user_arn,
            "SshUsername": ssh_username,
            "SshPublicKey": ssh_public_key,
            "AllowSelfManagement": allow_self_management,
        },
    )
