"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of tags that are applied to the specified stack or layer.

    Args:
        resource_arn(str): The stack or layer's Amazon Resource Number (ARN).
        max_results(int, optional): Do not use. A validation exception occurs if you add a MaxResults parameter to a ListTagsRequest call. . Defaults to None.
        next_token(str, optional): Do not use. A validation exception occurs if you add a NextToken parameter to a ListTagsRequest call. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.tags.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.tags.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="list_tags",
        op_kwargs={
            "ResourceArn": resource_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
