"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, stack_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Requests a description of a stack's provisioning parameters.  Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The stack ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.stack.provisioning_parameter.describe_all(
                ctx, stack_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.stack.provisioning_parameter.describe_all stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_stack_provisioning_parameters",
        op_kwargs={"StackId": stack_id},
    )
