"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def clone(
    hub,
    ctx,
    source_stack_id: str,
    service_role_arn: str,
    name: str = None,
    region: str = None,
    vpc_id: str = None,
    attributes: Dict = None,
    default_instance_profile_arn: str = None,
    default_os: str = None,
    hostname_theme: str = None,
    default_availability_zone: str = None,
    default_subnet_id: str = None,
    custom_json: str = None,
    configuration_manager: Dict = None,
    chef_configuration: Dict = None,
    use_custom_cookbooks: bool = None,
    use_opsworks_security_groups: bool = None,
    custom_cookbooks_source: Dict = None,
    default_ssh_key_name: str = None,
    clone_permissions: bool = None,
    clone_app_ids: List = None,
    default_root_device_type: str = None,
    agent_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a clone of a specified stack. For more information, see Clone a Stack. By default, all parameters are set to the values used by the parent stack.  Required Permissions: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        source_stack_id(str): The source stack ID.
        name(str, optional): The cloned stack name. Defaults to None.
        region(str, optional): The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see Regions and Endpoints. Defaults to None.
        vpc_id(str, optional): The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All instances are launched into this VPC, and you cannot change the ID later.   If your account supports EC2 Classic, the default value is no VPC.   If your account does not support EC2 Classic, the default value is the default VPC for the specified region.   If the VPC ID corresponds to a default VPC and you have specified either the DefaultAvailabilityZone or the DefaultSubnetId parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.  If you specify a nondefault VPC ID, note the following:   It must belong to a VPC in your account that is in the specified region.   You must specify a value for DefaultSubnetId.   For more information about how to use AWS OpsWorks Stacks with a VPC, see Running a Stack in a VPC. For more information about default VPC and EC2 Classic, see Supported Platforms. . Defaults to None.
        attributes(Dict, optional): A list of stack attributes and values as key/value pairs to be added to the cloned stack. Defaults to None.
        service_role_arn(str): The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role for you. You can obtain an existing stack's IAM ARN programmatically by calling DescribePermissions. For more information about IAM ARNs, see Using Identifiers.  You must set this parameter to a valid service role ARN or the action will fail; there is no default value. You can specify the source stack's service role ARN, if you prefer, but you must do so explicitly. .
        default_instance_profile_arn(str, optional): The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see Using Identifiers. Defaults to None.
        default_os(str, optional): The stack's operating system, which must be set to one of the following.   A supported Linux operating system: An Amazon Linux version, such as Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux 2015.03.   A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu 14.04 LTS, or Ubuntu 12.04 LTS.    CentOS Linux 7     Red Hat Enterprise Linux 7     Microsoft Windows Server 2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express, Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft Windows Server 2012 R2 with SQL Server Web.   A custom AMI: Custom. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see Using Custom AMIs.   The default option is the parent stack's operating system. For more information about supported operating systems, see AWS OpsWorks Stacks Operating Systems.  You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to Windows or Windows to Linux. . Defaults to None.
        hostname_theme(str, optional): The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host names for the stack's instances. By default, HostnameTheme is set to Layer_Dependent, which creates host names by appending integers to the layer's short name. The other themes are:    Baked_Goods     Clouds     Europe_Cities     Fruits     Greek_Deities_and_Titans     Legendary_creatures_from_Japan     Planets_and_Moons     Roman_Deities     Scottish_Islands     US_Cities     Wild_Cats    To obtain a generated host name, call GetHostNameSuggestion, which returns a host name based on the current theme. Defaults to None.
        default_availability_zone(str, optional): The cloned stack's default Availability Zone, which must be in the specified region. For more information, see Regions and Endpoints. If you also specify a value for DefaultSubnetId, the subnet must be in the same zone. For more information, see the VpcId parameter description. . Defaults to None.
        default_subnet_id(str, optional): The stack's default VPC subnet ID. This parameter is required if you specify a value for the VpcId parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for DefaultAvailabilityZone, the subnet must be in that zone. For information on default values and when this parameter is required, see the VpcId parameter description. . Defaults to None.
        custom_json(str, optional): A string that contains user-defined, custom JSON. It is used to override the corresponding default stack configuration JSON values. The string should be in the following format:  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"  For more information about custom JSON, see Use Custom JSON to Modify the Stack Configuration Attributes . Defaults to None.
        configuration_manager(Dict, optional): The configuration manager. When you clone a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12. Defaults to None.
        chef_configuration(Dict, optional): A ChefConfiguration object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see Create a New Stack. Defaults to None.
        use_custom_cookbooks(bool, optional): Whether to use custom cookbooks. Defaults to None.
        use_opsworks_security_groups(bool, optional): Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers. AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With UseOpsworksSecurityGroups you can instead provide your own custom security groups. UseOpsworksSecurityGroups has the following settings:    True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it but you cannot delete the built-in security group.   False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.   For more information, see Create a New Stack. Defaults to None.
        custom_cookbooks_source(Dict, optional): Contains the information required to retrieve an app or cookbook from a repository. For more information, see Adding Apps or Cookbooks and Recipes. Defaults to None.
        default_ssh_key_name(str, optional): A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see  Using SSH to Communicate with an Instance and  Managing SSH Access. You can override this setting by specifying a different key pair, or no key pair, when you  create an instance. . Defaults to None.
        clone_permissions(bool, optional): Whether to clone the source stack's permissions. Defaults to None.
        clone_app_ids(List, optional): A list of source stack app IDs to be included in the cloned stack. Defaults to None.
        default_root_device_type(str, optional): The default root device type. This value is used by default for all instances in the cloned stack, but you can override it when you create an instance. For more information, see Storage for the Root Device. Defaults to None.
        agent_version(str, optional): The default AWS OpsWorks Stacks agent version. You have the following options:   Auto-update - Set this parameter to LATEST. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.   Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.   The default setting is LATEST. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.  You can also specify an agent version when you create or update an instance, which overrides the stack's default setting. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.stack.init.clone(
                ctx, source_stack_id=value, service_role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.stack.init.clone source_stack_id=value, service_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="clone_stack",
        op_kwargs={
            "SourceStackId": source_stack_id,
            "Name": name,
            "Region": region,
            "VpcId": vpc_id,
            "Attributes": attributes,
            "ServiceRoleArn": service_role_arn,
            "DefaultInstanceProfileArn": default_instance_profile_arn,
            "DefaultOs": default_os,
            "HostnameTheme": hostname_theme,
            "DefaultAvailabilityZone": default_availability_zone,
            "DefaultSubnetId": default_subnet_id,
            "CustomJson": custom_json,
            "ConfigurationManager": configuration_manager,
            "ChefConfiguration": chef_configuration,
            "UseCustomCookbooks": use_custom_cookbooks,
            "UseOpsworksSecurityGroups": use_opsworks_security_groups,
            "CustomCookbooksSource": custom_cookbooks_source,
            "DefaultSshKeyName": default_ssh_key_name,
            "ClonePermissions": clone_permissions,
            "CloneAppIds": clone_app_ids,
            "DefaultRootDeviceType": default_root_device_type,
            "AgentVersion": agent_version,
        },
    )


async def create(
    hub,
    ctx,
    name: str,
    region: str,
    service_role_arn: str,
    default_instance_profile_arn: str,
    vpc_id: str = None,
    attributes: Dict = None,
    default_os: str = None,
    hostname_theme: str = None,
    default_availability_zone: str = None,
    default_subnet_id: str = None,
    custom_json: str = None,
    configuration_manager: Dict = None,
    chef_configuration: Dict = None,
    use_custom_cookbooks: bool = None,
    use_opsworks_security_groups: bool = None,
    custom_cookbooks_source: Dict = None,
    default_ssh_key_name: str = None,
    default_root_device_type: str = None,
    agent_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new stack. For more information, see Create a New Stack.  Required Permissions: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        name(str): The stack name.
        region(str): The stack's AWS region, such as ap-south-1. For more information about Amazon regions, see Regions and Endpoints.  In the AWS CLI, this API maps to the --stack-region parameter. If the --stack-region parameter and the AWS CLI common parameter --region are set to the same value, the stack uses a regional endpoint. If the --stack-region parameter is not set, but the AWS CLI --region parameter is, this also results in a stack with a regional endpoint. However, if the --region parameter is set to us-east-1, and the --stack-region parameter is set to one of the following, then the stack uses a legacy or classic region: us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2. In this case, the actual API endpoint of the stack is in us-east-1. Only the preceding regions are supported as classic regions in the us-east-1 API endpoint. Because it is a best practice to choose the regional endpoint that is closest to where you manage AWS, we recommend that you use regional endpoints for new stacks. The AWS CLI common --region parameter always specifies a regional API endpoint; it cannot be used to specify a classic AWS OpsWorks Stacks region. .
        vpc_id(str, optional): The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All instances are launched into this VPC. You cannot change the ID later.   If your account supports EC2-Classic, the default value is no VPC.   If your account does not support EC2-Classic, the default value is the default VPC for the specified region.   If the VPC ID corresponds to a default VPC and you have specified either the DefaultAvailabilityZone or the DefaultSubnetId parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively. If you specify a nondefault VPC ID, note the following:   It must belong to a VPC in your account that is in the specified region.   You must specify a value for DefaultSubnetId.   For more information about how to use AWS OpsWorks Stacks with a VPC, see Running a Stack in a VPC. For more information about default VPC and EC2-Classic, see Supported Platforms. . Defaults to None.
        attributes(Dict, optional): One or more user-defined key-value pairs to be added to the stack attributes. Defaults to None.
        service_role_arn(str): The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see Using Identifiers.
        default_instance_profile_arn(str): The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see Using Identifiers.
        default_os(str, optional): The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance. You can specify one of the following.   A supported Linux operating system: An Amazon Linux version, such as Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux 2015.03.   A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu 14.04 LTS, or Ubuntu 12.04 LTS.    CentOS Linux 7     Red Hat Enterprise Linux 7    A supported Windows operating system, such as Microsoft Windows Server 2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express, Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft Windows Server 2012 R2 with SQL Server Web.   A custom AMI: Custom. You specify the custom AMI you want to use when you create instances. For more information, see  Using Custom AMIs.   The default option is the current Amazon Linux version. For more information about supported operating systems, see AWS OpsWorks Stacks Operating Systems. Defaults to None.
        hostname_theme(str, optional): The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, HostnameTheme is set to Layer_Dependent, which creates host names by appending integers to the layer's short name. The other themes are:    Baked_Goods     Clouds     Europe_Cities     Fruits     Greek_Deities_and_Titans     Legendary_creatures_from_Japan     Planets_and_Moons     Roman_Deities     Scottish_Islands     US_Cities     Wild_Cats    To obtain a generated host name, call GetHostNameSuggestion, which returns a host name based on the current theme. Defaults to None.
        default_availability_zone(str, optional): The stack's default Availability Zone, which must be in the specified region. For more information, see Regions and Endpoints. If you also specify a value for DefaultSubnetId, the subnet must be in the same zone. For more information, see the VpcId parameter description. . Defaults to None.
        default_subnet_id(str, optional): The stack's default VPC subnet ID. This parameter is required if you specify a value for the VpcId parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for DefaultAvailabilityZone, the subnet must be in that zone. For information on default values and when this parameter is required, see the VpcId parameter description. . Defaults to None.
        custom_json(str, optional): A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"  For more information about custom JSON, see Use Custom JSON to Modify the Stack Configuration Attributes. Defaults to None.
        configuration_manager(Dict, optional): The configuration manager. When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12. Defaults to None.
        chef_configuration(Dict, optional): A ChefConfiguration object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see Create a New Stack. Defaults to None.
        use_custom_cookbooks(bool, optional): Whether the stack uses custom cookbooks. Defaults to None.
        use_opsworks_security_groups(bool, optional): Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers. AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With UseOpsworksSecurityGroups you can instead provide your own custom security groups. UseOpsworksSecurityGroups has the following settings:    True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.   False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.   For more information, see Create a New Stack. Defaults to None.
        custom_cookbooks_source(Dict, optional): Contains the information required to retrieve an app or cookbook from a repository. For more information, see Adding Apps or Cookbooks and Recipes. Defaults to None.
        default_ssh_key_name(str, optional): A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see  Using SSH to Communicate with an Instance and  Managing SSH Access. You can override this setting by specifying a different key pair, or no key pair, when you  create an instance. . Defaults to None.
        default_root_device_type(str, optional): The default root device type. This value is the default for all instances in the stack, but you can override it when you create an instance. The default option is instance-store. For more information, see Storage for the Root Device. Defaults to None.
        agent_version(str, optional): The default AWS OpsWorks Stacks agent version. You have the following options:   Auto-update - Set this parameter to LATEST. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.   Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.   The default setting is the most recent release of the agent. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.  You can also specify an agent version when you create or update an instance, which overrides the stack's default setting. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.stack.init.create(
                ctx,
                name=value,
                region=value,
                service_role_arn=value,
                default_instance_profile_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.stack.init.create name=value, region=value, service_role_arn=value, default_instance_profile_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="create_stack",
        op_kwargs={
            "Name": name,
            "Region": region,
            "VpcId": vpc_id,
            "Attributes": attributes,
            "ServiceRoleArn": service_role_arn,
            "DefaultInstanceProfileArn": default_instance_profile_arn,
            "DefaultOs": default_os,
            "HostnameTheme": hostname_theme,
            "DefaultAvailabilityZone": default_availability_zone,
            "DefaultSubnetId": default_subnet_id,
            "CustomJson": custom_json,
            "ConfigurationManager": configuration_manager,
            "ChefConfiguration": chef_configuration,
            "UseCustomCookbooks": use_custom_cookbooks,
            "UseOpsworksSecurityGroups": use_opsworks_security_groups,
            "CustomCookbooksSource": custom_cookbooks_source,
            "DefaultSshKeyName": default_ssh_key_name,
            "DefaultRootDeviceType": default_root_device_type,
            "AgentVersion": agent_version,
        },
    )


async def delete(hub, ctx, stack_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a specified stack. You must first delete all instances, layers, and apps or deregister registered instances. For more information, see Shut Down a Stack.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The stack ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.stack.init.delete(ctx, stack_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.stack.init.delete stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="delete_stack",
        op_kwargs={"StackId": stack_id},
    )


async def describe_all(hub, ctx, stack_ids: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Requests a description of one or more stacks.  Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        stack_ids(List, optional): An array of stack IDs that specify the stacks to be described. If you omit this parameter, DescribeStacks returns a description of every stack. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.stack.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.stack.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_stacks",
        op_kwargs={"StackIds": stack_ids},
    )


async def start(hub, ctx, stack_id: str) -> None:
    r"""
    **Autogenerated function**

    Starts a stack's instances.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The stack ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.stack.init.start(ctx, stack_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.stack.init.start stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="start_stack",
        op_kwargs={"StackId": stack_id},
    )


async def stop(hub, ctx, stack_id: str) -> None:
    r"""
    **Autogenerated function**

    Stops a specified stack.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The stack ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.stack.init.stop(ctx, stack_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.stack.init.stop stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="stop_stack",
        op_kwargs={"StackId": stack_id},
    )


async def update(
    hub,
    ctx,
    stack_id: str,
    name: str = None,
    attributes: Dict = None,
    service_role_arn: str = None,
    default_instance_profile_arn: str = None,
    default_os: str = None,
    hostname_theme: str = None,
    default_availability_zone: str = None,
    default_subnet_id: str = None,
    custom_json: str = None,
    configuration_manager: Dict = None,
    chef_configuration: Dict = None,
    use_custom_cookbooks: bool = None,
    custom_cookbooks_source: Dict = None,
    default_ssh_key_name: str = None,
    default_root_device_type: str = None,
    use_opsworks_security_groups: bool = None,
    agent_version: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates a specified stack.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The stack ID.
        name(str, optional): The stack's new name. Defaults to None.
        attributes(Dict, optional): One or more user-defined key-value pairs to be added to the stack attributes. Defaults to None.
        service_role_arn(str, optional): Do not use this parameter. You cannot update a stack's service role. Defaults to None.
        default_instance_profile_arn(str, optional): The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see Using Identifiers. Defaults to None.
        default_os(str, optional): The stack's operating system, which must be set to one of the following:   A supported Linux operating system: An Amazon Linux version, such as Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux 2015.03.   A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu 14.04 LTS, or Ubuntu 12.04 LTS.    CentOS Linux 7     Red Hat Enterprise Linux 7    A supported Windows operating system, such as Microsoft Windows Server 2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express, Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft Windows Server 2012 R2 with SQL Server Web.   A custom AMI: Custom. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see Using Custom AMIs.   The default option is the stack's current operating system. For more information about supported operating systems, see AWS OpsWorks Stacks Operating Systems. Defaults to None.
        hostname_theme(str, optional): The stack's new host name theme, with spaces replaced by underscores. The theme is used to generate host names for the stack's instances. By default, HostnameTheme is set to Layer_Dependent, which creates host names by appending integers to the layer's short name. The other themes are:    Baked_Goods     Clouds     Europe_Cities     Fruits     Greek_Deities_and_Titans     Legendary_creatures_from_Japan     Planets_and_Moons     Roman_Deities     Scottish_Islands     US_Cities     Wild_Cats    To obtain a generated host name, call GetHostNameSuggestion, which returns a host name based on the current theme. Defaults to None.
        default_availability_zone(str, optional): The stack's default Availability Zone, which must be in the stack's region. For more information, see Regions and Endpoints. If you also specify a value for DefaultSubnetId, the subnet must be in the same zone. For more information, see CreateStack. . Defaults to None.
        default_subnet_id(str, optional): The stack's default VPC subnet ID. This parameter is required if you specify a value for the VpcId parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for DefaultAvailabilityZone, the subnet must be in that zone. For information on default values and when this parameter is required, see the VpcId parameter description. . Defaults to None.
        custom_json(str, optional): A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack configuration JSON values or to pass data to recipes. The string should be in the following format:  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"  For more information about custom JSON, see Use Custom JSON to Modify the Stack Configuration Attributes. Defaults to None.
        configuration_manager(Dict, optional): The configuration manager. When you update a stack, we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12. Defaults to None.
        chef_configuration(Dict, optional): A ChefConfiguration object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see Create a New Stack. Defaults to None.
        use_custom_cookbooks(bool, optional): Whether the stack uses custom cookbooks. Defaults to None.
        custom_cookbooks_source(Dict, optional): Contains the information required to retrieve an app or cookbook from a repository. For more information, see Adding Apps or Cookbooks and Recipes. Defaults to None.
        default_ssh_key_name(str, optional): A default Amazon EC2 key-pair name. The default value is none. If you specify a key-pair name, AWS OpsWorks Stacks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see  Using SSH to Communicate with an Instance and  Managing SSH Access. You can override this setting by specifying a different key pair, or no key pair, when you  create an instance. . Defaults to None.
        default_root_device_type(str, optional): The default root device type. This value is used by default for all instances in the stack, but you can override it when you create an instance. For more information, see Storage for the Root Device. Defaults to None.
        use_opsworks_security_groups(bool, optional): Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers. AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. UseOpsworksSecurityGroups allows you to provide your own custom security groups instead of using the built-in groups. UseOpsworksSecurityGroups has the following settings:    True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.   False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on. Custom security groups are required only for those layers that need custom settings.   For more information, see Create a New Stack. Defaults to None.
        agent_version(str, optional): The default AWS OpsWorks Stacks agent version. You have the following options:   Auto-update - Set this parameter to LATEST. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.   Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.   The default setting is LATEST. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.  You can also specify an agent version when you create or update an instance, which overrides the stack's default setting. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.stack.init.update(ctx, stack_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.stack.init.update stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="update_stack",
        op_kwargs={
            "StackId": stack_id,
            "Name": name,
            "Attributes": attributes,
            "ServiceRoleArn": service_role_arn,
            "DefaultInstanceProfileArn": default_instance_profile_arn,
            "DefaultOs": default_os,
            "HostnameTheme": hostname_theme,
            "DefaultAvailabilityZone": default_availability_zone,
            "DefaultSubnetId": default_subnet_id,
            "CustomJson": custom_json,
            "ConfigurationManager": configuration_manager,
            "ChefConfiguration": chef_configuration,
            "UseCustomCookbooks": use_custom_cookbooks,
            "CustomCookbooksSource": custom_cookbooks_source,
            "DefaultSshKeyName": default_ssh_key_name,
            "DefaultRootDeviceType": default_root_device_type,
            "UseOpsworksSecurityGroups": use_opsworks_security_groups,
            "AgentVersion": agent_version,
        },
    )
