"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    stack_id: str = None,
    instance_id: str = None,
    service_error_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes AWS OpsWorks Stacks service errors.  Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions. This call accepts only one resource-identifying parameter.

    Args:
        stack_id(str, optional): The stack ID. If you use this parameter, DescribeServiceErrors returns descriptions of the errors associated with the specified stack. Defaults to None.
        instance_id(str, optional): The instance ID. If you use this parameter, DescribeServiceErrors returns descriptions of the errors associated with the specified instance. Defaults to None.
        service_error_ids(List, optional): An array of service error IDs. If you use this parameter, DescribeServiceErrors returns descriptions of the specified errors. Otherwise, it returns a description of every error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.service_error.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.service_error.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_service_errors",
        op_kwargs={
            "StackId": stack_id,
            "InstanceId": instance_id,
            "ServiceErrorIds": service_error_ids,
        },
    )
